package com.xebialabs.plugin.manager.scheduler

import com.xebialabs.plugin.manager.service.LocalPluginService
import grizzled.slf4j.Logging
import org.springframework.scheduling.annotation.Scheduled

class PluginRepositoryUpdateScheduler(val pluginService: LocalPluginService) extends Logging {
  @Scheduled(cron = "0 0 0 * * *")
  def updatePluginsRepository(): Unit = {
    try {
      pluginService.update()
      logger.info("Plugins repository updated")
    } catch {
      case e: Exception => logger.error("Error while loading the plugins", e)
    }
  }
}
