package com.xebialabs.plugin.manager.repository.nexus

import com.xebialabs.plugin.manager.metadata.Version
import org.apache.pekko.http.scaladsl.marshallers.sprayjson.SprayJsonSupport
import spray.json._


trait NexusJsonProtocol extends SprayJsonSupport with DefaultJsonProtocol
  with Version.Protocol {

  implicit val artifactLinkFormat: RootJsonFormat[ArtifactLink] =
    jsonFormat(ArtifactLink.apply, "extension", "classifier")

  implicit val artifactHitsFormat: RootJsonFormat[ArtifactHit] =
    jsonFormat(ArtifactHit.apply, "repositoryId", "artifactLinks")

  implicit val artifactMetadataFormat: RootJsonFormat[ArtifactMetadata] =
    jsonFormat(ArtifactMetadata.apply(_: String, _: String, _: String, _: String), "groupId", "artifactId", "version", "packaging")

  implicit val artifactResultFormat: RootJsonFormat[ArtifactResult] =
    jsonFormat(ArtifactResult.apply, "groupId", "artifactId", "version", "latestRelease", "latestReleaseRepositoryId", "artifactHits")

  implicit val repositoryDetailsFormat: RootJsonFormat[RepoDetails] =
    jsonFormat(RepoDetails.apply, "repositoryId", "repositoryName", "repositoryContentClass", "repositoryKind", "repositoryPolicy", "repositoryURL")

  implicit val nexusArtifactResultsFormat: RootJsonFormat[NexusArtifactResults] =
    jsonFormat(NexusArtifactResults, "totalCount", "from", "count", "tooManyResults", "collapsed", "repoDetails", "data")

}
