/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager.startup;

import com.xebialabs.plugin.manager.compatibility.Jdk17Compatibility$;
import com.xebialabs.plugin.manager.compatibility.Jdk17ReportUtils$;
import com.xebialabs.plugin.manager.metadata.XLProduct;
import com.xebialabs.plugin.manager.metadata.XLProduct$;
import com.xebialabs.plugin.manager.model.DbPlugin;
import com.xebialabs.plugin.manager.model.DbPlugin$;
import com.xebialabs.plugin.manager.model.DbPlugin$DbPluginOps$;
import com.xebialabs.plugin.manager.model.FilePlugin;
import com.xebialabs.plugin.manager.model.FilePlugin$;
import com.xebialabs.plugin.manager.model.FilePlugin$FilePluginOps$;
import com.xebialabs.plugin.manager.repository.sql.SqlPluginRepository;
import com.xebialabs.plugin.manager.rest.api.PluginSource$;
import com.xebialabs.plugin.manager.rest.api.PluginStatus$;
import com.xebialabs.plugin.manager.util.PluginsTraverser$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Marker;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005]b\u0001\u0002\n\u0014\u0001yA\u0001\"\f\u0001\u0003\u0006\u0004%\tA\f\u0005\to\u0001\u0011\t\u0011)A\u0005_!A\u0001\b\u0001BC\u0002\u0013\u0005\u0011\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003;\u0011!1\u0005A!b\u0001\n\u00039\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u000bM\u0003A\u0011\u0001+\t\u000bM\u0003A\u0011\u0001.\t\u000fu\u0003!\u0019!C\u0001=\"1Q\r\u0001Q\u0001\n}CQA\u001a\u0001\u0005\u0002\u001dDQA\u001a\u0001\u0005\u0002-DQA\u001c\u0001\u0005\n=Dq!a\u0005\u0001\t\u0013\t)\u0002C\u0004\u0002\"\u0001!I!a\t\t\u000f\u0005%\u0002\u0001\"\u0003\u0002,!9\u0011\u0011\u0007\u0001\u0005\n\u0005M\"A\u0004)mk\u001eLg.\u00169he\u0006$WM\u001d\u0006\u0003)U\tqa\u001d;beR,\bO\u0003\u0002\u0017/\u00059Q.\u00198bO\u0016\u0014(B\u0001\r\u001a\u0003\u0019\u0001H.^4j]*\u0011!dG\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001H\u0001\u0004G>l7\u0001A\n\u0004\u0001})\u0003C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g\r\u0005\u0002'W5\tqE\u0003\u0002)S\u0005)1\u000f\u001c45U*\t!&\u0001\u0005he&T(\u0010\\3e\u0013\tasEA\u0004M_\u001e<\u0017N\\4\u0002!AdWoZ5o%\u0016\u0004xn]5u_JLX#A\u0018\u0011\u0005A*T\"A\u0019\u000b\u0005I\u001a\u0014aA:rY*\u0011A'F\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001\u001c2\u0005M\u0019\u0016\u000f\u001c)mk\u001eLgNU3q_NLGo\u001c:z\u0003E\u0001H.^4j]J+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\baJ|G-^2u+\u0005Q\u0004CA\u001eC\u001d\ta\u0004\t\u0005\u0002>C5\taH\u0003\u0002@;\u00051AH]8pizJ!!Q\u0011\u0002\rA\u0013X\rZ3g\u0013\t\u0019EI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0003\u0006\n\u0001\u0002\u001d:pIV\u001cG\u000fI\u0001\u000ba2,x-\u001b8t\t&\u0014X#\u0001%\u0011\u0005%\u0003V\"\u0001&\u000b\u0005-c\u0015\u0001\u00024jY\u0016T!!\u0014(\u0002\u00079LwNC\u0001P\u0003\u0011Q\u0017M^1\n\u0005ES%\u0001\u0002)bi\"\f1\u0002\u001d7vO&t7\u000fR5sA\u00051A(\u001b8jiz\"B!V,Y3B\u0011a\u000bA\u0007\u0002'!)Qf\u0002a\u0001_!)\u0001h\u0002a\u0001u!)ai\u0002a\u0001\u0011R\u0019Qk\u0017/\t\u000b5B\u0001\u0019A\u0018\t\u000baB\u0001\u0019\u0001\u001e\u0002\u0013ad\u0007K]8ek\u000e$X#A0\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\t,\u0012\u0001C7fi\u0006$\u0017\r^1\n\u0005\u0011\f'!\u0003-M!J|G-^2u\u0003)AH\u000e\u0015:pIV\u001cG\u000fI\u0001\u000fkB<'/\u00193f!2,x-\u001b8t)\u0005A\u0007C\u0001\u0011j\u0013\tQ\u0017EA\u0004C_>dW-\u00198\u0015\u0005!d\u0007\"B7\r\u0001\u0004A\u0017aF2iK\u000e\\'\nZ62o\r{W\u000e]1uS\nLG.\u001b;z\u0003=)\bo\u001a:bI\u0016|eMZ5dS\u0006dG\u0003\u00029\u0000\u0003\u0007\u00012!\u001d<z\u001d\t\u0011HO\u0004\u0002>g&\t!%\u0003\u0002vC\u00059\u0001/Y2lC\u001e,\u0017BA<y\u0005\u0011a\u0015n\u001d;\u000b\u0005U\f\u0003C\u0001>~\u001b\u0005Y(B\u0001?\u0016\u0003\u0015iw\u000eZ3m\u0013\tq8P\u0001\u0006GS2,\u0007\u000b\\;hS:Da!!\u0001\u000e\u0001\u0004\u0001\u0018!\u00034t!2,x-\u001b8t\u0011\u001d\t)!\u0004a\u0001\u0003\u000f\t\u0011\u0002\u001a2QYV<\u0017N\\:\u0011\u000bE\fI!!\u0004\n\u0007\u0005-\u0001PA\u0002TKF\u00042A_A\b\u0013\r\t\tb\u001f\u0002\t\t\n\u0004F.^4j]\u0006aQ\u000f]4sC\u0012,Gj\\2bYR1\u0011qCA\u000f\u0003?\u00012\u0001IA\r\u0013\r\tY\"\t\u0002\u0005+:LG\u000f\u0003\u0004\u0002\u00029\u0001\r\u0001\u001d\u0005\b\u0003\u000bq\u0001\u0019AA\u0004\u0003M\u0019G.Z1okB4%o\\7ECR\f'-Y:f)\u0011\t9\"!\n\t\u000f\u0005\u001dr\u00021\u0001\u0002\u000e\u0005AAM\u0019)mk\u001eLg.A\fxe&$Xm\u00144gS\u000eL\u0017\r\u001c+p\t\u0006$\u0018MY1tKR\u0019\u00110!\f\t\r\u0005=\u0002\u00031\u0001z\u0003!17\u000f\u00157vO&t\u0017\u0001F<sSR,Gj\\2bYR{G)\u0019;bE\u0006\u001cX\r\u0006\u0003\u0002\u0018\u0005U\u0002BBA\u0018#\u0001\u0007\u0011\u0010")
public class PluginUpgrader
implements Logging {
    private final SqlPluginRepository pluginRepository;
    private final String product;
    private final Path pluginsDir;
    private final XLProduct xlProduct;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        PluginUpgrader pluginUpgrader = this;
        synchronized (pluginUpgrader) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public SqlPluginRepository pluginRepository() {
        return this.pluginRepository;
    }

    public String product() {
        return this.product;
    }

    public Path pluginsDir() {
        return this.pluginsDir;
    }

    public XLProduct xlProduct() {
        return this.xlProduct;
    }

    public boolean upgradePlugins() {
        return this.upgradePlugins(false);
    }

    public boolean upgradePlugins(boolean checkJdk17Compatibility) {
        Map dbPluginsBySource = this.pluginRepository().getAllWithBytes().groupBy((Function1 & Serializable)x$1 -> x$1.source().toString());
        List<FilePlugin> upgradedOfficialPlugins = PluginsTraverser$.MODULE$.traverseAndReturnOfficial(this.pluginsDir(), (Function2<Enumeration.Value, List<FilePlugin>, List<FilePlugin>>)(Function2 & Serializable)(officialSource, plugins) -> this.upgradeOfficial((List<FilePlugin>)plugins, (Seq<DbPlugin>)((Seq)dbPluginsBySource.getOrElse((Object)officialSource.toString(), (Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty()))), (Function1<List<FilePlugin>, BoxedUnit>)(Function1 & Serializable)plugins -> {
            this.upgradeLocal((List<FilePlugin>)plugins, (Seq<DbPlugin>)((Seq)dbPluginsBySource.getOrElse((Object)PluginSource$.MODULE$.LOCAL().toString(), (Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty())));
            return BoxedUnit.UNIT;
        });
        this.pluginRepository().updateAllPluginsStatusTo(PluginStatus$.MODULE$.INSTALLED());
        if (checkJdk17Compatibility) {
            Seq<DbPlugin> dbplugins = this.pluginRepository().getAllWithBytes();
            Seq dbPluginsFiltered = (Seq)dbplugins.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DbPlugin$DbPluginOps$.MODULE$.doesntExistIn$extension(DbPlugin$.MODULE$.DbPluginOps(x$2), (Seq<FilePlugin>)upgradedOfficialPlugins)));
            Seq pluginCompatibility = (Seq)dbPluginsFiltered.map((Function1 & Serializable)plugin -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plugin.name()), (Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> Jdk17Compatibility$.MODULE$.isCompatible((DbPlugin)plugin))));
            this.logger().info((Function0 & Serializable)() -> Jdk17ReportUtils$.MODULE$.displayCompatibilityReport((Map<String, Try<Object>>)pluginCompatibility.iterator().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), new StringBuffer()));
            return pluginCompatibility.forall((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)PluginUpgrader.$anonfun$upgradePlugins$10(b)));
        }
        return true;
    }

    private List<FilePlugin> upgradeOfficial(List<FilePlugin> fsPlugins, Seq<DbPlugin> dbPlugins) {
        this.debug((Function0<Object>)(Function0 & Serializable)() -> "Processing list of official plugins found on the filesystem " + fsPlugins + " and in the database " + dbPlugins);
        ((IterableOnceOps)dbPlugins.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DbPlugin$DbPluginOps$.MODULE$.higherVersionExistsIn$extension(DbPlugin$.MODULE$.DbPluginOps(x$3), (Seq<FilePlugin>)fsPlugins)))).foreach((Function1 & Serializable)dbPlugin -> {
            this.cleanupFromDatabase(dbPlugin);
            return BoxedUnit.UNIT;
        });
        return fsPlugins.filter((Function1 & Serializable)fsPlugin -> BoxesRunTime.boxToBoolean((boolean)PluginUpgrader.$anonfun$upgradeOfficial$4(dbPlugins, fsPlugin))).map((Function1 & Serializable)fsPlugin -> this.writeOfficialToDatabase((FilePlugin)fsPlugin));
    }

    private void upgradeLocal(List<FilePlugin> fsPlugins, Seq<DbPlugin> dbPlugins) {
        this.debug((Function0<Object>)(Function0 & Serializable)() -> "Processing list of local plugins found on the filesystem " + fsPlugins + " and in the database " + dbPlugins);
        fsPlugins.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FilePlugin$FilePluginOps$.MODULE$.doesntExistIn$extension(FilePlugin$.MODULE$.FilePluginOps(x$4), (Seq<DbPlugin>)dbPlugins))).foreach((Function1 & Serializable)fsPlugin -> {
            this.writeLocalToDatabase(fsPlugin);
            return BoxedUnit.UNIT;
        });
    }

    private void cleanupFromDatabase(DbPlugin dbPlugin) {
        this.info((Function0<Object>)(Function0 & Serializable)() -> "Removing plugin " + dbPlugin.name() + " from database");
        this.pluginRepository().delete(dbPlugin);
    }

    private FilePlugin writeOfficialToDatabase(FilePlugin fsPlugin) {
        this.info((Function0<Object>)(Function0 & Serializable)() -> "Synchronizing plugin " + fsPlugin.name() + " from filesystem to database");
        this.pluginRepository().insert(FilePlugin$FilePluginOps$.MODULE$.toOfficialDbPlugin$extension(FilePlugin$.MODULE$.FilePluginOps(fsPlugin), this.xlProduct()));
        return fsPlugin;
    }

    private void writeLocalToDatabase(FilePlugin fsPlugin) {
        this.info((Function0<Object>)(Function0 & Serializable)() -> "Synchronizing plugin " + fsPlugin.name() + " from filesystem to database");
        this.pluginRepository().insert(FilePlugin$FilePluginOps$.MODULE$.toLocalDbPlugin$extension(FilePlugin$.MODULE$.FilePluginOps(fsPlugin)));
    }

    public static final /* synthetic */ boolean $anonfun$upgradePlugins$10(Tuple2 b) {
        return ((Try)b._2()).isSuccess() && BoxesRunTime.unboxToBoolean((Object)((Try)b._2()).get());
    }

    public static final /* synthetic */ boolean $anonfun$upgradeOfficial$4(Seq dbPlugins$1, FilePlugin fsPlugin) {
        return FilePlugin$FilePluginOps$.MODULE$.doesntExistIn$extension(FilePlugin$.MODULE$.FilePluginOps(fsPlugin), (Seq<DbPlugin>)dbPlugins$1) || FilePlugin$FilePluginOps$.MODULE$.isHigherVersionThanAMatchIn$extension(FilePlugin$.MODULE$.FilePluginOps(fsPlugin), (Seq<DbPlugin>)dbPlugins$1);
    }

    public PluginUpgrader(SqlPluginRepository pluginRepository, String product, Path pluginsDir) {
        this.pluginRepository = pluginRepository;
        this.product = product;
        this.pluginsDir = pluginsDir;
        Logging.$init$((Logging)this);
        this.xlProduct = XLProduct$.MODULE$.fromString(product);
    }

    public PluginUpgrader(SqlPluginRepository pluginRepository, String product) {
        this(pluginRepository, product, Paths.get("plugins", new String[0]));
    }
}

