package com.xebialabs.plugin.manager.rest.json

import com.xebialabs.plugin.manager.service._
import org.springframework.stereotype.Component
import spray.json.{DefaultJsonProtocol, JsArray, JsBoolean, JsObject, JsString, JsValue}

import java.io.{IOException, OutputStream, OutputStreamWriter}
import java.lang.annotation.Annotation
import java.lang.reflect.Type
import javax.ws.rs.core.{MediaType, MultivaluedMap}
import javax.ws.rs.ext.{MessageBodyWriter, Provider}
import javax.ws.rs.{Produces, WebApplicationException}
import scala.collection.mutable

@Component
@Provider
@Produces(Array(MediaType.APPLICATION_JSON))
class InstallationResultJsonWriter extends MessageBodyWriter[InstallationResult] with DefaultJsonProtocol {

  override def isWriteable(`type`: Class[_], genericType: Type, annotations: Array[Annotation],
                           mediaType: MediaType): Boolean = classOf[InstallationResult].isAssignableFrom(`type`)

  @throws[IOException]
  @throws[WebApplicationException]
  override def writeTo(installationResult: InstallationResult, `type`: Class[_], genericType: Type,
                       annotations: Array[Annotation], mediaType: MediaType,
                       httpHeaders: MultivaluedMap[String, AnyRef], entityStream: OutputStream): Unit = {
    val dataMap: mutable.Map[String, JsValue] = mutable.Map.empty
    dataMap.put("message", JsString(installationResult.message))

    installationResult match {
      case InstallationSuccess(_, requiresRestart, _) =>
        dataMap.put("requiresRestart", JsBoolean(requiresRestart))
      case UpdateSuccess(_, requiresRestart) =>
        dataMap.put("requiresRestart", JsBoolean(requiresRestart))
      case _ => ()
    }

    if (installationResult.warnings.nonEmpty) {
      dataMap.put("warnings", JsArray(installationResult.warnings.map(JsString(_)).toVector))
    }
    if (installationResult.errors.nonEmpty) {
      dataMap.put("errors", JsArray(installationResult.errors.map(JsString(_)).toVector))
    }

    val jsObject = JsObject(dataMap.toMap).toJson.compactPrint
    val writer = new OutputStreamWriter(entityStream)
    writer.write(jsObject)
    writer.flush()
  }

}
