package com.xebialabs.plugin.manager.validator

import scala.collection.mutable.ArrayBuffer

class TypeSystemValidationResults {
  private val results: ArrayBuffer[TypeSystemValidationResult] = ArrayBuffer()

  def isFailure: Boolean = {
    !isSuccess
  }

  def isSuccess: Boolean = {
    results.forall(_.isSuccess)
  }

  def requiresRestart: Boolean = {
    results.exists(_.requiresRestart)
  }

  def add(validationResult: TypeSystemValidationResult): TypeSystemValidationResults = {
    results += validationResult
    this
  }

  def restartReason: String = {
    results.collect {
      case r => r.restartReason
    }.mkString(",\n")
  }

  def failureReason: String = {
    results.collect {
      case r => r.failureReason
    }.mkString(",\n")
  }
}

object TypeSystemValidationResults {
  def apply(): TypeSystemValidationResults = new TypeSystemValidationResults()
}