package com.xebialabs.plugin.manager.validator


sealed trait TypeSystemValidationResult {

  def isSuccess: Boolean

  def requiresRestart: Boolean

  def restartReason: String

  def failureReason: String

}

sealed trait FailedTypeSystemValidation extends TypeSystemValidationResult {
  override def isSuccess: Boolean = false

  override def requiresRestart: Boolean = false
}

sealed trait SuccessfulTypeSystemValidation extends TypeSystemValidationResult {
  override def isSuccess: Boolean = true

  override def failureReason: String = ""
}

case class RestartNeeded(restartReason: String) extends SuccessfulTypeSystemValidation {
  val requiresRestart = true
}

case class RestartNotNeeded(restartReason: String = "") extends SuccessfulTypeSystemValidation {
  val requiresRestart = false
}

case class UnableToCreateTypeSystem(failureReason: String, restartReason: String = "") extends FailedTypeSystemValidation

case class UnsupportedPluginType(failureReason: String, restartReason: String = "") extends FailedTypeSystemValidation
