package com.xebialabs.plugin.manager.validator

import com.xebialabs.deployit.booter.local.LocalBooter
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlplatform.synthetic.xml.SyntheticXmlDocument

import scala.jdk.CollectionConverters.ListHasAsScala

abstract class SyntheticValidator {
  def validate(synthetic: SyntheticXmlDocument): ValidationResult
}

class SyntheticValidatorAtInstallation(descriptorRegistryWrapper: DescriptorRegistryWrapper) extends SyntheticValidator {

  override def validate(synthetic: SyntheticXmlDocument): ValidationResult = {
    if (LocalBooter.isInitialized) {
      validateInternal(synthetic)
    } else {
      TypeSystemNotInitialized()
    }
  }

  def validateInternal(synthetic: SyntheticXmlDocument): ValidationResult = {
    val types = synthetic.getTypes.asScala
    val conflictingTypes = types.filter(typeSpec => descriptorRegistryWrapper.exists(typeSpec.getType)).toSeq

    if (conflictingTypes.nonEmpty) {
      PluginTypesAlreadyExist(toFullyQualifiedNames(conflictingTypes.map(_.getType)))
    } else {
      PluginValid()
    }
  }

  def toFullyQualifiedNames(types: Seq[Type]): Seq[String] = {
    types.map(t => s"${t.getPrefix}.${t.getName}")
  }

}

class SyntheticValidatorAtUpdate extends SyntheticValidator {
  override def validate(synthetic: SyntheticXmlDocument): ValidationResult = ???
}
