package com.xebialabs.plugin.manager.util

import com.xebialabs.deployit.checksum.DefaultChecksumAlgorithmProviderFactory
import com.xebialabs.deployit.util.JavaCryptoUtils

import java.security.MessageDigest

object ChecksumUtil {

  def calculateChecksum(bytes: Array[Byte]): String = {
    val hash: MessageDigest = DefaultChecksumAlgorithmProviderFactory.defaultComparisonAlgorithm.getMessageDigest
    hash.update(bytes)
    JavaCryptoUtils.digest(hash)
  }

}
