package com.xebialabs.plugin.manager.config.impl;

import com.xebialabs.plugin.manager.config.*;

import java.util.List;

/**
 * This set of classes is a default implementation. It is used by XLD's Spring Boot style
 * @ConfigurationProperties, by tests in this module, and by the xl-plugin-metadata-builder.
 *
 * It's pointless to have three copies lying around.
 */
public class PluginManagerPropertiesImpl implements PluginManagerProperties {

    private List<?> repositories;
    private List<?> servers;
    private String pluginSource;

    public void setServers(List<ServerImpl> servers) {
        this.servers = servers;
    }
    public List<Server> getServers() {
        return (List<Server>) servers;
    }

    public void setRepositories(List<RepositoryImpl> repositories) {
        this.repositories = repositories;
    }

    public List<? extends Repository> getRepositories() {
        return (List<Repository>) repositories;
    }

    public void setPluginSource(String pluginSource) {
        this.pluginSource = pluginSource;
    }

    public String getPluginSource() {
        return pluginSource;
    }

    public static class RepositoryImpl implements Repository {
        private String name;
        private String enabled;
        private String nexusGroupId;
        private String nexusPackagingType;
        private String nexusRepositoryId;
        private String repositoryType;
        private String serverRef;
        private String xlComponent;
        private ServerImpl server;
        private NexusMetadataArtifactImpl nexusMetadataArtifact;

        public static class NexusMetadataArtifactImpl implements NexusMetadataArtifact {
            private String artifactId;
            private String groupId;
            private String version;

            public void setArtifactId(String artifactId) {
                this.artifactId = artifactId;
            }

            public void setGroupId(String groupId) {
                this.groupId = groupId;
            }

            public String getArtifactId() {
                return artifactId;
            }

            public String getGroupId() {
                return groupId;
            }

            public String getVersion() {
                return version;
            }

            public void setVersion(String version) {
                this.version = version;
            }
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setEnabled(String enabled) {
            this.enabled = enabled;
        }

        public void setNexusGroupId(String nexusGroupId) {
            this.nexusGroupId = nexusGroupId;
        }

        public void setNexusPackagingType(String nexusPackagingType) {
            this.nexusPackagingType = nexusPackagingType;
        }

        public void setNexusRepositoryId(String nexusRepositoryId) {
            this.nexusRepositoryId = nexusRepositoryId;
        }

        public void setRepositoryType(String repositoryType) {
            this.repositoryType = repositoryType;
        }

        public void setServerRef(String serverRef) {
            this.serverRef = serverRef;
        }

        public void setXlComponent(String xlComponent) {
            this.xlComponent = xlComponent;
        }

        public void setNexusMetadataArtifact(NexusMetadataArtifactImpl nexusMetadataArtifact) {
            this.nexusMetadataArtifact = nexusMetadataArtifact;
        }

        public void setServer(ServerImpl server) {
            this.server = server;
        }

        public String getName() {
            return name;
        }

        public String getEnabled() {
            return enabled;
        }

        public String getNexusGroupId() {
            return nexusGroupId;
        }

        public String getNexusPackagingType() {
            return nexusPackagingType;
        }

        public String getNexusRepositoryId() {
            return nexusRepositoryId;
        }

        public String getRepositoryType() {
            return repositoryType;
        }

        public String getServerRef() {
            return serverRef;
        }

        public String getXlComponent() {
            return xlComponent;
        }

        public NexusMetadataArtifact getNexusMetadataArtifact() {
            return nexusMetadataArtifact;
        }

        public Server getServer() {
            return server;
        }
    }

    public static class ServerImpl implements Server {
        private String name;
        private String serverType;
        private String url;
        private CredentialsImpl credentials;
        private ProxyImpl proxy;

        public void setName(String name) {
            this.name = name;
        }

        public void setServerType(String serverType) {
            this.serverType = serverType;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setCredentials(CredentialsImpl credentials) {
            this.credentials = credentials;
        }

        public void setProxy(ProxyImpl proxy) {
            this.proxy = proxy;
        }

        public String getName() {
            return name;
        }

        public String getServerType() {
            return serverType;
        }

        public String getUrl() {
            return url;
        }

        public Credentials getCredentials() {
            return credentials;
        }

        public Proxy getProxy() {
            return proxy;
        }

        public static class ProxyImpl implements Proxy {
            private String host;
            private Integer port;
            private CredentialsImpl credentials;

            public void setHost(String host) {
                this.host = host;
            }

            public void setPort(Integer port) {
                this.port = port;
            }

            public void setCredentials(CredentialsImpl credentials) {
                this.credentials = credentials;
            }

            public String getHost() {
                return host;
            }

            public Integer getPort() {
                return port;
            }

            public Credentials getCredentials() {
                return credentials;
            }
        }

        public static class CredentialsImpl implements Credentials {
            private String username;
            private String password;

            public void setUsername(String username) {
                this.username = username;
            }

            public void setPassword(String password) {
                this.password = password;
            }

            public String getUsername() {
                return username;
            }

            public String getPassword() {
                return password;
            }
        }
    }
}