package com.xebialabs.plugin.manager.repository.storage

import java.io.{File, InputStream}
import java.nio.file.Path

import com.xebialabs.plugin.manager.PluginId
import com.xebialabs.plugin.manager.metadata.{ArtifactId, ExtendedMetadata, PluginsMetadata}


trait PluginMetadataStorage {
  def repositoryName: String

  def clear(): Unit

  def store(data: Seq[PluginId.Artifact], pluginsMetadata: Map[ArtifactId, ExtendedMetadata]): Unit

  def get(id: ArtifactId): Option[PluginsMetadata]

  def get(id: PluginId.Artifact): Option[PluginsMetadata] =
    get(id.toArtifactId)
      .filter(_.versions.contains(Some(id.version)))

  def storeLogos(data: InputStream): Unit

  def getLogo(id: ArtifactId): Option[File]

  def search(name: Option[String]): Map[ArtifactId, PluginsMetadata]

  def list(): Map[ArtifactId, PluginsMetadata] = search(None)
}

sealed abstract class PluginMetadataStorageException(msg: String, e: Throwable = null) extends Exception(msg, e)

object PluginMetadataStorageException {
  case class UnknownPlugin(repository: String, id: PluginId) extends PluginMetadataStorageException(
    s"Unknown plugin in repository '$repository': '${id.id}'"
  )
}



