package com.xebialabs.plugin.manager.metadata

import akka.http.scaladsl.marshallers.sprayjson.SprayJsonSupport
import spray.json._


sealed trait XLProduct

object XLProduct {
  case object XLRelease extends XLProduct
  case object XLDeploy extends XLProduct
  case object XLImpact extends XLProduct

  trait Protocol extends SprayJsonSupport with DefaultJsonProtocol {
    val xlProductString: XLProduct => String = {
      case XLRelease => "XL Release"
      case XLDeploy => "XL Deploy"
      case XLImpact => "XL Impact"
    }
    val xlProductWriter: JsonWriter[XLProduct] = p => xlProductString(p).toJson
    val xlProductReader: JsonReader[XLProduct] = jsonReader[XLProduct] {
      case JsString("XL Release") => XLRelease
      case JsString("XL Deploy") => XLDeploy
      case JsString("XL Impact") => XLImpact
      case unknown =>
        deserializationError(s"Unknown XL product: '$unknown'")
    }
    implicit val xlProductFormat: JsonFormat[XLProduct] = jsonFormat(xlProductReader, xlProductWriter)
  }
}