package com.xebialabs.plugin.manager.repository

import java.io.{ByteArrayInputStream, File}

import com.xebialabs.plugin.manager.metadata.{ArtifactId, ExtendedMetadata, PluginsMetadata}
import com.xebialabs.plugin.manager.{Plugin, PluginId}
import org.joda.time.DateTime

import scala.concurrent.{ExecutionContext, Future}


trait PluginsRepository {
  implicit val ec: ExecutionContext

  def name: String

  def lastUpdated: Option[DateTime]

  def update(): Future[DateTime]

  def fetchMetadata: Future[Map[ArtifactId, ExtendedMetadata]]

  def fetchLogos: Future[ByteArrayInputStream]

  def get(id: PluginId.Artifact): Future[Plugin]

  def getMetadata(id: ArtifactId): Option[PluginsMetadata]

  def getLogo(id: ArtifactId): Option[File]

  def search(query: Option[String]): Future[Map[ArtifactId, PluginsMetadata]]

  def list(): Future[Map[ArtifactId, PluginsMetadata]] = search(None)

  def search(query: String): Future[Map[ArtifactId, PluginsMetadata]] = search(Some(query))

}

