package com.xebialabs.plugin.manager.metadata

import akka.http.scaladsl.marshallers.sprayjson.SprayJsonSupport
import spray.json._


case class Requirement(product: XLProduct, version: VersionExpr)

object Requirement {
  trait Protocol extends SprayJsonSupport with DefaultJsonProtocol
    with XLProduct.Protocol
    with VersionExpr.Protocol {

    val requirementWriter: JsonWriter[Requirement] = jsonWriter[Requirement] {
      case Requirement(product, version) => JsObject(
        "product" -> product.toJson,
        "version" -> version.toJson
      )
    }
    val requirementReader: JsonReader[Requirement] = jsonReader[Requirement] {
      case obj: JsObject =>
        obj.getFields("product", "version") match {
          case Seq(product, version) =>
            Requirement(product.convertTo[XLProduct], version.convertTo[VersionExpr])
          case other =>
            deserializationError(s"Cannot parse requirement: '$other'")
        }
      case unknown =>
        deserializationError(s"Cannot parse requirement: '$unknown'")
    }
    implicit val requirementFormat: JsonFormat[Requirement] = jsonFormat(requirementReader, requirementWriter)
  }
}
