package com.xebialabs.plugin.manager.metadata

import akka.http.scaladsl.marshallers.sprayjson.SprayJsonSupport
import spray.json._

sealed trait SupportedBy

object SupportedBy {
  case object XebiaLabs extends SupportedBy
  case object Community extends SupportedBy
  case class Partner(name: String) extends SupportedBy
  case object Unsupported extends SupportedBy



  trait Protocol extends SprayJsonSupport with DefaultJsonProtocol {
    private val partnerSupportPrefix = "Partner: "

    implicit val supportedByReader: JsonReader[SupportedBy] = jsonReader[SupportedBy] {
      case JsString("XebiaLabs") => SupportedBy.XebiaLabs
      case JsString("Community") => SupportedBy.Community
      case JsString("Unsupported") => SupportedBy.Unsupported
      case JsString(other) if other.startsWith(partnerSupportPrefix) =>
        SupportedBy.Partner(other.drop(partnerSupportPrefix.length))
      case unknown => deserializationError(s"Illegal value for 'supportedBy' field: '$unknown'")
    }
    implicit val supportedByWriter: JsonWriter[SupportedBy] = jsonWriter[SupportedBy] {
      case SupportedBy.XebiaLabs => "XebiaLabs".toJson
      case SupportedBy.Community => "Community".toJson
      case SupportedBy.Unsupported => "Unsupported".toJson
      case SupportedBy.Partner(name) => (partnerSupportPrefix ++ name).toJson
    }
    implicit val supportedByFormat: JsonFormat[SupportedBy] = jsonFormat(supportedByReader, supportedByWriter)

  }
}