/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager;

import com.xebialabs.plugin.manager.LocalPluginManager$;
import com.xebialabs.plugin.manager.Plugin;
import com.xebialabs.plugin.manager.PluginId;
import com.xebialabs.plugin.manager.PluginId$;
import com.xebialabs.plugin.manager.PluginId$Artifact$;
import com.xebialabs.plugin.manager.PluginId$LocalFile$;
import com.xebialabs.plugin.manager.PluginId$PluginIdOps$;
import com.xebialabs.plugin.manager.PluginManager;
import com.xebialabs.plugin.manager.config.ConfigWrapper$;
import com.xebialabs.plugin.manager.metadata.ArtifactId;
import com.xebialabs.plugin.manager.metadata.ExtendedMetadata;
import com.xebialabs.plugin.manager.metadata.Version;
import com.xebialabs.plugin.manager.metadata.Version$;
import com.xebialabs.plugin.manager.rest.api.PluginSource$;
import com.xebialabs.plugin.manager.rest.api.PluginStatus$;
import com.xebialabs.plugin.manager.sql.DbPlugin;
import com.xebialabs.plugin.manager.sql.DbPlugin$;
import com.xebialabs.plugin.manager.sql.SqlPluginRepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.slf4j.Marker;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005-w!B\u000f\u001f\u0011\u00039c!B\u0015\u001f\u0011\u0003Q\u0003\"B\u0019\u0002\t\u0003\u0011\u0004bB\u001a\u0002\u0005\u0004%\t\u0001\u000e\u0005\u0007{\u0005\u0001\u000b\u0011B\u001b\t\u000fy\n!\u0019!C\u0001\u007f!1\u0001*\u0001Q\u0001\n\u0001CQ!S\u0001\u0005\u0002)3A!\u000b\u0010\u00013\"AQ\r\u0003B\u0001B\u0003%a\r\u0003\u0005q\u0011\t\u0005\t\u0015!\u0003r\u0011\u0015\t\u0004\u0002\"\u0001x\u0011\u0015\u0019\u0004\u0002\"\u0001|\u0011\u001da\bB1A\u0005\u0004uDq!!\u0003\tA\u0003%a\u0010C\u0004\u0002\f!!\t!!\u0004\t\u000f\u0005U\u0001\u0002\"\u0011\u0002\u0018!9\u0011Q\u0005\u0005\u0005B\u0005]\u0001bBA\u0014\u0011\u0011\u0005\u0013\u0011\u0006\u0005\b\u0003gAA\u0011IA\u001b\u0011\u001d\ty\u0007\u0003C!\u0003cBq!! \t\t\u0003\ny\bC\u0004\u0002\n\"!\t%a#\t\u000f\u0005=\u0005\u0002\"\u0005\u0002\u0012\"9\u0011Q\u0013\u0005\u0005\u0012\u0005]\u0005bBAP\u0011\u0011E\u0011\u0011\u0015\u0005\b\u0003OCA\u0011CAU\u0011\u001d\ti\f\u0003C\u0005\u0003\u007fCq!!2\t\t\u0013\t9-\u0001\nM_\u000e\fG\u000e\u00157vO&tW*\u00198bO\u0016\u0014(BA\u0010!\u0003\u001di\u0017M\\1hKJT!!\t\u0012\u0002\rAdWoZ5o\u0015\t\u0019C%A\u0005yK\nL\u0017\r\\1cg*\tQ%A\u0002d_6\u001c\u0001\u0001\u0005\u0002)\u00035\taD\u0001\nM_\u000e\fG\u000e\u00157vO&tW*\u00198bO\u0016\u00148CA\u0001,!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aJ\u0001\u0005]\u0006lW-F\u00016!\t14(D\u00018\u0015\tA\u0014(\u0001\u0003mC:<'\"\u0001\u001e\u0002\t)\fg/Y\u0005\u0003y]\u0012aa\u0015;sS:<\u0017!\u00028b[\u0016\u0004\u0013A\u00039mk\u001eLgn\u001d#jeV\t\u0001\t\u0005\u0002B\r6\t!I\u0003\u0002D\t\u0006!a-\u001b7f\u0015\t)\u0015(A\u0002oS>L!a\u0012\"\u0003\tA\u000bG\u000f[\u0001\fa2,x-\u001b8t\t&\u0014\b%A\u0004mSN$H)\u001b:\u0015\u0005-;\u0006c\u0001'U\u0001:\u0011QJ\u0015\b\u0003\u001dFk\u0011a\u0014\u0006\u0003!\u001a\na\u0001\u0010:p_Rt\u0014\"\u0001\u0018\n\u0005Mk\u0013a\u00029bG.\fw-Z\u0005\u0003+Z\u0013\u0001\u0002T1{s2K7\u000f\u001e\u0006\u0003'6BQ\u0001W\u0004A\u0002\u0001\u000b1\u0001Z5s'\u0011A1FW/\u0011\u0005!Z\u0016B\u0001/\u001f\u00055\u0001F.^4j]6\u000bg.Y4feB\u0011alY\u0007\u0002?*\u0011\u0001-Y\u0001\u0006g24GG\u001b\u0006\u0002E\u0006AqM]5{u2,G-\u0003\u0002e?\n9Aj\\4hS:<\u0017!\u0005:fa>\u001c\u0018\u000e^8ss\u001e\u0013x.\u001e9JIB!qm\u001b8o\u001d\tA\u0017\u000e\u0005\u0002O[%\u0011!.L\u0001\u0007!J,G-\u001a4\n\u00051l'aA'ba*\u0011!.\f\t\u0003O>L!\u0001P7\u0002'M\fH\u000e\u00157vO&t'+\u001a9pg&$xN]=\u0011\u0005I,X\"A:\u000b\u0005Qt\u0012aA:rY&\u0011ao\u001d\u0002\u0014'Fd\u0007\u000b\\;hS:\u0014V\r]8tSR|'/\u001f\u000b\u0004qfT\bC\u0001\u0015\t\u0011\u0015)7\u00021\u0001g\u0011\u0015\u00018\u00021\u0001r+\u0005q\u0017AA3d+\u0005q\bcA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007i\u0013AC2p]\u000e,(O]3oi&!\u0011qAA\u0001\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/A\u0002fG\u0002\nA$\u001a8tkJ,\u0007\u000b\\;hS:\u001cH)\u001b:fGR|'/_#ySN$8\u000f\u0006\u0002\u0002\u0010A\u0019A&!\u0005\n\u0007\u0005MQF\u0001\u0003V]&$\u0018!\u00047jgRLen\u001d;bY2,G\r\u0006\u0002\u0002\u001aA)A*a\u0007\u0002 %\u0019\u0011Q\u0004,\u0003\u0007M+\u0017\u000fE\u0002)\u0003CI1!a\t\u001f\u0005!\u0001F.^4j]&#\u0017!\u00077jgRLen\u001d;bY2,Gm\u00148GS2,7/_:uK6\fq!\u001b8ti\u0006dG\u000e\u0006\u0003\u0002\u0010\u0005-\u0002BB\u0011\u0013\u0001\u0004\ti\u0003E\u0002)\u0003_I1!!\r\u001f\u0005\u0019\u0001F.^4j]\u0006Yq-\u001a;QYV<\u0017N\u001c\"z))\t9$a\u0011\u0002b\u0005\u0015\u0014\u0011\u000e\t\u0006Y\u0005e\u0012QH\u0005\u0004\u0003wi#AB(qi&|g\u000eE\u0002s\u0003\u007fI1!!\u0011t\u0005!!%\r\u00157vO&t\u0007bBA#'\u0001\u0007\u0011qI\u0001\re\u0016\u0004xn]5u_JL\u0018\n\u001a\t\u0005\u0003\u0013\nIF\u0004\u0003\u0002L\u0005USBAA'\u0015\u0011\ty%!\u0015\u0002\u0007\u0005\u0004\u0018NC\u0002\u0002Ty\tAA]3ti&!\u0011qKA'\u00031\u0001F.^4j]N{WO]2f\u0013\u0011\tY&!\u0018\u0003\u000bY\u000bG.^3\n\u0007\u0005}SFA\u0006F]VlWM]1uS>t\u0007BBA2'\u0001\u0007a.A\u0004he>,\b/\u00133\t\r\u0005\u001d4\u00031\u0001o\u0003)\t'\u000f^5gC\u000e$\u0018\n\u001a\u0005\b\u0003W\u001a\u0002\u0019AA7\u0003\u001d1XM]:j_:\u0004B\u0001LA\u001d]\u0006\u0019b-\u001a;dQBcWoZ5o'R\fG/^:fgR\u0011\u00111\u000f\t\u0006O.t\u0017Q\u000f\t\u0005\u0003o\nIF\u0004\u0003\u0002L\u0005e\u0014\u0002BA>\u0003\u001b\nA\u0002\u00157vO&t7\u000b^1ukN\f\u0011\"\u001e8j]N$\u0018\r\u001c7\u0015\t\u0005\u0005\u0015q\u0011\t\u0004Y\u0005\r\u0015bAAC[\t9!i\\8mK\u0006t\u0007BB\u0011\u0016\u0001\u0004\ti$\u0001\u0011sKZ,'\u000f\u001e)sKZLw.^:WKJ\u001c\u0018n\u001c8JM:+7-Z:tCJLH\u0003BA\b\u0003\u001bCa!\t\fA\u0002\u0005u\u0012a\u00047jgRLen\u001d;bY2,G-\u00138\u0015\t\u0005e\u00111\u0013\u0005\u00061^\u0001\r\u0001Q\u0001\nY&\u001cH\u000fT8dC2$B!!'\u0002\u001cB!A\nVA\u0010\u0011\u0019\ti\n\u0007a\u0001\u0001\u0006AAn\\2bY\u0012K'/\u0001\bmSN$(+\u001a9pg&$xN]=\u0015\t\u0005e\u00151\u0015\u0005\u0007\u0003KK\u0002\u0019\u0001!\u0002\u001bI,\u0007o\\:ji>\u0014\u0018\u0010R5s\u0003Ma\u0017n\u001d;QYV<\u0017N\u001c#je\u0016\u001cGo\u001c:z)\u0011\tY+!/\u0015\t\u0005e\u0015Q\u0016\u0005\b\u0003_S\u0002\u0019AAY\u0003\u00051\u0007C\u0002\u0017\u00024:\f9,C\u0002\u000266\u0012\u0011BR;oGRLwN\\\u0019\u0011\u000b1\nI$a\b\t\r\u0005m&\u00041\u0001A\u0003\u0011\u0001\u0018\r\u001e5\u0002\u0015Q|\u0007\u000b\\;hS:LE\r\u0006\u0003\u0002 \u0005\u0005\u0007bBAb7\u0001\u0007\u0011QH\u0001\tI\n\u0004F.^4j]\u0006iBo\u001c#c!2,x-\u001b8XSRD\u0017J\\:uC2dW\rZ*uCR,8\u000f\u0006\u0003\u0002>\u0005%\u0007BB\u0011\u001d\u0001\u0004\ty\u0002")
public class LocalPluginManager
implements PluginManager,
Logging {
    private final Map<String, String> repositoryGroupId;
    private final SqlPluginRepository sqlPluginRepository;
    private final ExecutionContext ec;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public static LazyList<Path> listDir(Path dir) {
        return LocalPluginManager$.MODULE$.listDir(dir);
    }

    public static Path pluginsDir() {
        return LocalPluginManager$.MODULE$.pluginsDir();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Future<Set<ArtifactId>> search(Option<String> query) {
        return PluginManager.search$(this, query);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        LocalPluginManager localPluginManager = this;
        synchronized (localPluginManager) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public String name() {
        return LocalPluginManager$.MODULE$.name();
    }

    @Override
    public ExecutionContext ec() {
        return this.ec;
    }

    public void ensurePluginsDirectoryExists() {
        LocalPluginManager$.MODULE$.pluginsDir().resolve(this.name()).toFile().mkdirs();
    }

    @Override
    public Seq<PluginId> listInstalled() {
        this.ensurePluginsDirectoryExists();
        Seq<DbPlugin> pluginsInDb = this.sqlPluginRepository.getAllWithoutBytes();
        LazyList pluginsOnFs = LocalPluginManager$.MODULE$.listDir(LocalPluginManager$.MODULE$.pluginsDir()).flatMap((Function1 & Serializable)dir -> this.listInstalledIn((Path)dir));
        Seq pluginsInDbNames = (Seq)pluginsInDb.map((Function1 & Serializable)x$1 -> x$1.name());
        LazyList filteredFsPlugins = pluginsOnFs.filterNot((Function1 & Serializable)fsPlugin -> BoxesRunTime.boxToBoolean((boolean)pluginsInDbNames.contains((Object)PluginId$PluginIdOps$.MODULE$.pluginName$extension(PluginId$.MODULE$.PluginIdOps(fsPlugin)))));
        return (Seq)((SeqOps)pluginsInDb.map((Function1 & Serializable)dbPlugin -> this.toPluginId((DbPlugin)dbPlugin))).concat((IterableOnce)filteredFsPlugins);
    }

    @Override
    public Seq<PluginId> listInstalledOnFilesystem() {
        this.ensurePluginsDirectoryExists();
        return LocalPluginManager$.MODULE$.listDir(LocalPluginManager$.MODULE$.pluginsDir()).flatMap((Function1 & Serializable)dir -> this.listInstalledIn((Path)dir));
    }

    @Override
    public void install(Plugin plugin) {
        block6: {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(11).append("install(").append(PluginId$PluginIdOps$.MODULE$.id$extension(PluginId$.MODULE$.PluginIdOps(plugin.id()))).append(", ").append(plugin.metadata()).append(")").toString());
            try {
                try {
                    Seq<DbPlugin> dbPlugins = this.sqlPluginRepository.getByName(PluginId$PluginIdOps$.MODULE$.pluginName$extension(PluginId$.MODULE$.PluginIdOps(plugin.id())));
                    DbPlugin dbPlugin = DbPlugin$.MODULE$.apply(plugin);
                    if (dbPlugins.size() == 1) {
                        this.sqlPluginRepository.update(dbPlugin, (DbPlugin)dbPlugins.head());
                        break block6;
                    }
                    this.sqlPluginRepository.insert(dbPlugin);
                }
                catch (Exception e) {
                    this.logger().error((Function0 & Serializable)() -> new StringBuilder(52).append("Error installing plugin ").append(PluginId$PluginIdOps$.MODULE$.id$extension(PluginId$.MODULE$.PluginIdOps(plugin.id()))).append(" to the database with error ").append(e.getMessage()).toString());
                }
            }
            finally {
                plugin.content().close();
            }
        }
    }

    @Override
    public Option<DbPlugin> getPluginBy(Enumeration.Value repositoryId, String groupId, String artifactId, Option<String> version) {
        return this.sqlPluginRepository.getPluginBy(repositoryId, groupId, artifactId, version);
    }

    @Override
    public Map<String, Enumeration.Value> fetchPluginStatuses() {
        return ((IterableOnceOps)this.sqlPluginRepository.getAllWithoutBytes().map((Function1 & Serializable)plugin -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plugin.name()), (Object)plugin.installationStatus()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public boolean uninstall(DbPlugin plugin) {
        return plugin.installationStatus().equals((Object)PluginStatus$.MODULE$.READY_FOR_INSTALL()) && this.sqlPluginRepository.delete(plugin) > 0;
    }

    @Override
    public void revertPreviousVersionIfNecessary(DbPlugin plugin) {
        LazyList pluginsOnFs = LocalPluginManager$.MODULE$.listDir(LocalPluginManager$.MODULE$.pluginsDir()).flatMap((Function1 & Serializable)dir -> this.listInstalledIn((Path)dir));
        LazyList fsPluginPreviousVersion = pluginsOnFs.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LocalPluginManager.$anonfun$revertPreviousVersionIfNecessary$2(plugin, x$2)));
        if (fsPluginPreviousVersion.isEmpty()) {
            this.debug((Function0<Object>)(Function0 & Serializable)() -> "Nothing to revert from the filesystem..");
        } else if (fsPluginPreviousVersion.size() > 1) {
            this.error((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(93).append("Found two or more plugins with identical name ").append(plugin.name()).append(" on the filesystem, aborting revert operation..").toString());
        } else {
            this.sqlPluginRepository.insert(this.toDbPluginWithInstalledStatus((PluginId)fsPluginPreviousVersion.head()));
        }
    }

    public Seq<PluginId> listInstalledIn(Path dir) {
        String string = ((Object)dir.getFileName()).toString();
        String string2 = this.name();
        return !(string != null ? !string.equals(string2) : string2 != null) ? this.listLocal(dir) : this.listRepository(dir);
    }

    public LazyList<PluginId> listLocal(Path localDir) {
        return this.listPluginDirectory(localDir, (Function1<String, Option<PluginId>>)(Function1 & Serializable)filename -> PluginId$LocalFile$.MODULE$.fromIdString(new StringBuilder(2).append(this.name()).append(":").append(PluginId$.MODULE$.localGroupId()).append(":").append((String)filename).toString()));
    }

    public LazyList<PluginId> listRepository(Path repositoryDir) {
        String repository = ((Object)repositoryDir.getFileName()).toString();
        return (LazyList)this.repositoryGroupId.get((Object)repository).map((Function1 & Serializable)groupId -> this.listPluginDirectory(repositoryDir, (Function1<String, Option<PluginId>>)(Function1 & Serializable)filename -> PluginId$Artifact$.MODULE$.fromIdString(new StringBuilder(2).append(repository).append(":").append((String)groupId).append(":").append((String)filename).toString()))).getOrElse((Function0 & Serializable)() -> package$.MODULE$.LazyList().empty());
    }

    public LazyList<PluginId> listPluginDirectory(Path path, Function1<String, Option<PluginId>> f) {
        return LocalPluginManager$.MODULE$.listDir(path).map((Function1 & Serializable)x$3 -> ((Object)x$3.getFileName()).toString()).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.endsWith(new StringBuilder(1).append(".").append(ConfigWrapper$.MODULE$.extension()).toString()))).flatMap(f);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private PluginId toPluginId(DbPlugin dbPlugin) {
        void var2_9;
        DbPlugin dbPlugin2 = dbPlugin;
        if (dbPlugin2 != null) {
            String name = dbPlugin2.name();
            Option<String> version = dbPlugin2.version();
            Enumeration.Value value = dbPlugin2.source();
            Enumeration.Value value2 = PluginSource$.MODULE$.LOCAL();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                PluginId.LocalFile localFile = PluginId$LocalFile$.MODULE$.apply(name, (Option<Version>)version.flatMap((Function1 & Serializable)v -> Version$.MODULE$.fromString((String)v)));
                return var2_9;
            }
        }
        if (dbPlugin2 == null) throw new MatchError((Object)dbPlugin2);
        String name = dbPlugin2.name();
        Option<String> version = dbPlugin2.version();
        String groupId = dbPlugin2.groupId();
        Enumeration.Value source = dbPlugin2.source();
        PluginId.Artifact artifact = PluginId$Artifact$.MODULE$.apply(source.toString(), groupId, name, (String)version.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), PluginId$Artifact$.MODULE$.apply$default$5());
        return var2_9;
    }

    private DbPlugin toDbPluginWithInstalledStatus(PluginId plugin) {
        DbPlugin dbPlugin = DbPlugin$.MODULE$.apply(new Plugin(plugin, (Option<ExtendedMetadata>)None$.MODULE$, LocalPluginManager.is$1(plugin)));
        Enumeration.Value x$1 = PluginStatus$.MODULE$.INSTALLED();
        long x$2 = dbPlugin.copy$default$1();
        String x$3 = dbPlugin.copy$default$2();
        Option<String> x$4 = dbPlugin.copy$default$3();
        String x$5 = dbPlugin.copy$default$4();
        String x$6 = dbPlugin.copy$default$5();
        Enumeration.Value x$7 = dbPlugin.copy$default$7();
        String x$8 = dbPlugin.copy$default$8();
        Option<Object> x$9 = dbPlugin.copy$default$9();
        Option<byte[]> x$10 = dbPlugin.copy$default$10();
        return dbPlugin.copy(x$2, x$3, x$4, x$5, x$6, x$1, x$7, x$8, x$9, x$10);
    }

    public static final /* synthetic */ boolean $anonfun$revertPreviousVersionIfNecessary$2(DbPlugin plugin$2, PluginId x$2) {
        return PluginId$PluginIdOps$.MODULE$.pluginName$extension(PluginId$.MODULE$.PluginIdOps(x$2)).equalsIgnoreCase(plugin$2.name());
    }

    private static final InputStream is$1(PluginId plugin$3) {
        return Files.newInputStream(LocalPluginManager$.MODULE$.pluginsDir().resolve(PluginId$PluginIdOps$.MODULE$.path$extension(PluginId$.MODULE$.PluginIdOps(plugin$3))).resolve(PluginId$PluginIdOps$.MODULE$.filename$extension(PluginId$.MODULE$.PluginIdOps(plugin$3))), new OpenOption[0]);
    }

    public LocalPluginManager(Map<String, String> repositoryGroupId, SqlPluginRepository sqlPluginRepository) {
        this.repositoryGroupId = repositoryGroupId;
        this.sqlPluginRepository = sqlPluginRepository;
        PluginManager.$init$(this);
        Logging.$init$((Logging)this);
        this.ec = ExecutionContext$.MODULE$.global();
    }
}

