package com.xebialabs.plugin.manager.rest.api

import com.xebialabs.plugin.manager.PluginId
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput

import java.util.Date
import javax.ws.rs._
import javax.ws.rs.core.MediaType.APPLICATION_JSON
import javax.ws.rs.core.{MediaType, Response}

@Path("/plugin-manager")
@Produces(Array(APPLICATION_JSON))
trait PluginResource { // add

  // list - upgrade method PluginResource.list() with PluginStatus information from the DB. The information is system (cluster) - wide.

  @POST
  @Path("repositories/{repositoryId}/install/{groupId}/{artifactId}/{version}")
  @Produces(Array(MediaType.APPLICATION_JSON))
  def installFromRepository(@PathParam("repositoryId") repositoryId: String,
                            @PathParam("groupId") groupId: String,
                            @PathParam("artifactId") artifactId: String,
                            @PathParam("version") version: String): Response

  @POST
  @Consumes(Array("multipart/form-data"))
  def install(input: MultipartFormDataInput, @QueryParam("pluginId") pluginId: String): ValidationResult

  @DELETE
  @Path("/delete/{repositoryId}/{groupId}/{artifactId}{version:(/.*)?}")
  def uninstall(@PathParam("repositoryId") repositoryId: String,
                @PathParam("groupId") groupId: String,
                @PathParam("artifactId") artifactId: String,
                @PathParam("version") version: String): Response

  @POST
  @Path("/apply")
  def apply() // applies the installation strategy to the whole system for plugins in ADDED status (propagates file to all nodes, restarts what's and if it's needed)

  // status <node identifier, node status>
  @GET
  @Path("/plugins/status")
  def status: Map[String, NodeStatus.Value]

  // list from marketplace - PluginResource.listRepository
  @POST
  @Path("/plugins/disable")
  def disable(plugin: PluginId)

  @POST
  @Path("/plugins/enable")
  def enable(plugin: PluginId)

  @GET
  @Produces(Array(MediaType.APPLICATION_JSON))
  def list(): Response

  @GET
  @Path("search/{query}") // TODO delete (unused)
  @Produces(Array(MediaType.APPLICATION_JSON))
  def search(@PathParam("query") query: String): Response

  @GET
  @Path("repositories")
  @Produces(Array(MediaType.APPLICATION_JSON))
  def listRepositories(): Response

  @POST
  @Path("repositories/{repositoryId}/update")
  def updateRepository(@PathParam("repositoryId") repositoryId: String): Date

  @GET
  @Path("repositories/{repositoryId}/list")
  @Produces(Array(MediaType.APPLICATION_JSON))
  def listRepository(@PathParam("repositoryId") repositoryId: String): Response

  @GET
  @Path("repositories/{repositoryId}/logo/{groupId}/{artifactId}")
  @Produces(Array("image/*"))
  def getLogo(@PathParam("repositoryId") repositoryId: String,
              @PathParam("groupId") groupId: String,
              @PathParam("artifactId") artifactId: String): Response

}