package com.xebialabs.plugin.manager.metadata

import akka.http.scaladsl.marshallers.sprayjson.SprayJsonSupport
import spray.json._


case class PluginMetadata(metadata: ExtendedMetadata, hasLogo: Boolean)

object PluginMetadata {
  trait Protocol extends SprayJsonSupport with DefaultJsonProtocol
    with ExtendedMetadata.Protocol {

    implicit val pluginsMetadataWriter: RootJsonWriter[PluginMetadata] = {
      case PluginMetadata(metadata, hasLogo) =>
        JsObject(
          "metadata" -> metadata.toJson,
          "hasLogo" -> hasLogo.toJson
        )
    }
  }
}


