package com.xebialabs.plugin.manager.repository

import java.io.{ByteArrayInputStream, File}

import com.xebialabs.plugin.manager.metadata.{ArtifactId, ExtendedMetadata, PluginMetadata, Version}
import com.xebialabs.plugin.manager.{Plugin, PluginId}
import org.joda.time.DateTime

import scala.concurrent.{ExecutionContext, Future}


trait PluginsRepository {
  implicit val ec: ExecutionContext

  def name: String

  def lastUpdated: Option[DateTime]

  def update(): Future[DateTime]

  def fetchMetadata: Future[Map[ArtifactId, ExtendedMetadata]]

  def fetchLogos: Future[ByteArrayInputStream]

  def get(id: PluginId.Artifact): Future[Plugin]

  def getMetadata(id: ArtifactId): Option[PluginMetadata]

  def getLogo(artifactId: String): Option[File]

  def search(query: Option[String]): Future[Map[ArtifactId, Option[PluginMetadata]]]

  def list(): Future[Map[ArtifactId, Option[PluginMetadata]]] = search(None)

  def search(query: String): Future[Map[ArtifactId, Option[PluginMetadata]]] = search(Some(query))

}

