/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license;

import com.xebialabs.license.License;
import com.xebialabs.license.LicenseEditionException;
import com.xebialabs.license.LicensePeriodExpiredException;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.LicensePropertyMap;
import com.xebialabs.license.LicenseType;
import com.xebialabs.license.LicenseViolationException;
import java.util.Arrays;
import java.util.List;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class LicenseVersion3
extends License {
    public static final LicenseType VERSION = LicenseType.VERSION_3;

    public LicenseVersion3(LicensePropertyMap values) throws LicenseViolationException {
        super(values);
    }

    @Override
    public LicenseType getLicenseVersion() {
        return VERSION;
    }

    @Override
    public List<LicenseProperty> getLicenseProperties() {
        return Arrays.asList(LicenseProperty.LICENSE_VERSION, LicenseProperty.PRODUCT, LicenseProperty.LICENSED_TO, LicenseProperty.CONTACT, LicenseProperty.REPOSITORY_ID, LicenseProperty.EXPIRES_AFTER, LicenseProperty.MAX_NUMBER_OF_USERS, LicenseProperty.MAX_NUMBER_OF_CIS, LicenseProperty.LICENSED_PLUGINS, LicenseProperty.SUPPORT_POLICY, LicenseProperty.EDITION);
    }

    @Override
    public List<LicenseProperty> getRequiredProperties() {
        return Arrays.asList(LicenseProperty.LICENSE_VERSION, LicenseProperty.PRODUCT, LicenseProperty.LICENSED_TO, LicenseProperty.CONTACT, LicenseProperty.EDITION);
    }

    @Override
    public void validateLicenseFormat() throws LicenseViolationException {
        super.validateLicenseFormat();
        this.validateEdition();
    }

    private void validateEdition() throws LicenseViolationException {
        if (!this.hasLicenseProperty(LicenseProperty.EDITION)) {
            throw new LicenseEditionException(String.format("For this version of %s, a license edition Enterprise, Trial or Unregistered is required, not the license contains none.", this.getStringValue(LicenseProperty.PRODUCT)));
        }
        String licenseEdition = this.getStringValue(LicenseProperty.EDITION);
        if (!Edition.contains(licenseEdition)) {
            throw new LicenseEditionException(String.format("For this version of %s, a license edition Enterprise, Trial or Unregistered is required. Edition type %s is invalid", this.getStringValue(LicenseProperty.PRODUCT), licenseEdition));
        }
    }

    @Override
    protected void validateSpecific() {
        if (this.values.getAsString(LicenseProperty.EDITION).equals(Edition.Trial.name())) {
            LocalDate expireDate = (LocalDate)this.values.get(LicenseProperty.EXPIRES_AFTER);
            if (expireDate == null) {
                throw new LicensePeriodExpiredException("Trial licenses require an expire date");
            }
            LocalDate maxExpireDate = LocalDate.now().plusDays(90);
            if (expireDate.isAfter((ReadablePartial)maxExpireDate)) {
                throw new LicensePeriodExpiredException(String.format("Trial licenses cannot be valid for more than %s days. This license is valid until %s", 90, expireDate));
            }
        }
    }

    public static enum Edition {
        Unregistered,
        Community,
        Enterprise,
        Trial;


        public static boolean contains(String editionName) {
            for (Edition edition : Edition.values()) {
                if (!edition.name().equals(editionName)) continue;
                return true;
            }
            return false;
        }
    }
}

