package com.xebialabs.license.service;

import com.xebialabs.license.*;
import org.joda.time.Period;

public interface LicenseService {

    License getLicense();

    /**
     * Checks whether the license is expired
     */
    boolean isLicenseExpired();

    /**
     * Returns the amount of time this license is still valid
     * @return a period. Returns period.ZERO if the license is expired
     */
    Period getValidPeriod();

    /**
     * Provide the product name.
     */
    String getProduct();

    /**
     * Validates whether XL Deploy server meets all the license requirements for the license on disk
     */
    void validate() throws LicenseViolationException;

    /**
     * Validates whether XL Deploy server meets all the license requirements for a license instance
     */
    void validate(License license) throws LicenseViolationException;

    /**
     * Reload the license file from the file system and {@link #validate()} it.
     */
    void reload() throws LicenseViolationException, LicenseParseException;

    /**
     * Provides an access to the counter
     */
    LicenseCiCounter getCounter();

    /**
     * Initialization that requires the repository
     */
    void initialize(LicenseCiCounterFactory ciCounterFactory);

    /**
     * Gives you a new LicenseTransaction object so you can keep track of what CIs were created during this JcrTransaction per thread.
     * @return a LicenseTransaction
     */
    LicenseTransaction startTransaction();

    /**
     * Rolls back any CI changes (deletions, creations, copies) that were performed as part of the given license transaction
     *
     * @param transaction a LicenseTransaction to rollback changes from
     */
    void rollbackTransaction(LicenseTransaction transaction);
}
