package com.xebialabs.license;

import java.util.Arrays;
import java.util.List;
import org.joda.time.LocalDate;

import static com.xebialabs.license.LicenseProperty.CONTACT;
import static com.xebialabs.license.LicenseProperty.EDITION;
import static com.xebialabs.license.LicenseProperty.EXPIRES_AFTER;
import static com.xebialabs.license.LicenseProperty.LICENSED_PLUGINS;
import static com.xebialabs.license.LicenseProperty.LICENSED_TO;
import static com.xebialabs.license.LicenseProperty.LICENSE_VERSION;
import static com.xebialabs.license.LicenseProperty.MAX_NUMBER_OF_CIS;
import static com.xebialabs.license.LicenseProperty.MAX_NUMBER_OF_USERS;
import static com.xebialabs.license.LicenseProperty.PRODUCT;
import static com.xebialabs.license.LicenseProperty.REPOSITORY_ID;
import static com.xebialabs.license.LicenseProperty.SUPPORT_POLICY;
import static java.lang.String.format;

@Deprecated
public class LicenseVersion3 extends License {
    public static final LicenseType VERSION = LicenseType.VERSION_3;

    public enum Edition3 {
        Unregistered,
        Community,
        Enterprise,
        Trial;

        public static boolean contains(String editionName) {
            for (Edition3 edition : Edition3.values()) {
                if (edition.name().equals(editionName)) {
                    return true;
                }
            }
            return false;
        }
    }

    public LicenseVersion3(LicensePropertyMap values) throws LicenseViolationException {
        super(values);
    }

    @Override
    public LicenseType getLicenseVersion() {
        return VERSION;
    }

    @Override
    public List<LicenseProperty> getLicenseProperties() {
        return Arrays.asList(LICENSE_VERSION, PRODUCT, LICENSED_TO, CONTACT, REPOSITORY_ID, EXPIRES_AFTER,
                MAX_NUMBER_OF_USERS, MAX_NUMBER_OF_CIS, LICENSED_PLUGINS, SUPPORT_POLICY, EDITION);
    }

    @Override
    public List<LicenseProperty> getRequiredProperties() {
        return Arrays.asList(LICENSE_VERSION, PRODUCT, LICENSED_TO, CONTACT, EDITION);
    }

    @Override
    public void validateLicenseFormat() throws LicenseViolationException {
        super.validateLicenseFormat();
        validateEdition();
    }

    private void validateEdition() throws LicenseViolationException {
        if (!hasLicenseProperty(LicenseProperty.EDITION)) {
            throw new LicenseEditionException(format("For this version of %s, a license edition Enterprise, Trial or Unregistered is required, not the license contains none.", getStringValue(LicenseProperty.PRODUCT)));
        }

        String licenseEdition = getStringValue(LicenseProperty.EDITION);
        if (!Edition3.contains(licenseEdition)) {
            throw new LicenseEditionException(format("For this version of %s, a license edition Enterprise, Trial or Unregistered is required. Edition type %s is invalid", getStringValue(LicenseProperty.PRODUCT), licenseEdition));
        }
    }

    @Override
    protected void validateSpecific() {
        if (values.getAsString(LicenseProperty.EDITION).equals(Edition3.Trial.name())) {
            final LocalDate expireDate = values.get(LicenseProperty.EXPIRES_AFTER);
            if (expireDate == null) {
                    throw new LicensePeriodExpiredException("Trial licenses require an expire date");
            }
            final LocalDate maxExpireDate = LocalDate.now().plusDays(MAX_TRIAL_LICENSE_VALIDITY);
            if (expireDate.isAfter(maxExpireDate)) {
                throw new LicensePeriodExpiredException(String.format("Trial licenses cannot be valid for more than %s days. This license is valid until %s",
                        MAX_TRIAL_LICENSE_VALIDITY, expireDate));

            }
        }
    }
}
