package com.xebialabs.license;

public enum LicenseType {
    NONE("NONE"),
    VERSION_1("1"),
    VERSION_2("2"),
    VERSION_3("3"),
    VERSION_4("4");

    private String type;

    LicenseType(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }

    public static LicenseType fromType(String type) {
        for (LicenseType licenseType : LicenseType.values()) {
            if (licenseType.type.equals(type)) {
                return licenseType;
            }
        }
        // Version 1 did have a null type property
        return LicenseType.VERSION_1;
    }
}
