/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xlplatform.endpoints;

import org.python.core.PyDictionary;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

/**
 * Request object of this class is always available as {@code request} inside Jython scripts which implement REST endpoints in XL extensions.
 */
@PublicApiRef
public class JythonRequest {

    public JythonRequest(final Object entity, final PyDictionary query) {
        this.entity = entity;
        this.query = query;
    }

    private Object entity = null;

    private PyDictionary query = new PyDictionary();

    /**
     * Returns a deserialized entity in case of {@code POST, PUT} request. Will return {@code null} for {@code GET, DELETE}.
     * If body of the request contained field {@code someField}, it will be accessible as {@code request.entity['someField']} in the script.
     */
    public Object getEntity() {
        return entity;
    }


    /**
     * Returns a dictionary of query parameters of the request. Example:
     * If the URL of the request was {@code /api/extension/test?count=2}
     * then parameter value will be accessible as {@code request.query['count']}.
     */
    public PyDictionary getQuery() {
        return query;
    }
}
