/**
 * Copyright © 2014-2016 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xlplatform.endpoints

import com.xebialabs.deployit.security.authentication.XlAuthenticationToken
import org.springframework.security.core.authority.SimpleGrantedAuthority
import org.springframework.security.core.Authentication

import collection.convert.ImplicitConversions._

case class AuthenticatedData(username: String, roles: Seq[String]) {
  def toAuthentication: Authentication = new XlAuthenticationToken(username, "", roles.map(new SimpleGrantedAuthority(_)))
}

object AuthenticatedData {
  def apply(auth: Authentication): AuthenticatedData = AuthenticatedData(auth.getName, auth.getAuthorities.map(_.getAuthority).toSeq)
  def apply(username: String): AuthenticatedData = AuthenticatedData(username, Seq())
}
