/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.platform.sso.oidc.policy.impl;

import com.xebialabs.platform.sso.oidc.exceptions.InvalidRoleClaimsListException;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.Assert;

public class DefaultClaimsToGrantedAuthoritiesPolicy
implements ClaimsToGrantedAuthoritiesPolicy {
    private static final Logger logger = LoggerFactory.getLogger(DefaultClaimsToGrantedAuthoritiesPolicy.class);
    private final String rolesClaimName;

    public DefaultClaimsToGrantedAuthoritiesPolicy(String rolesClaimName) {
        Assert.hasText((String)rolesClaimName, (String)"rolesClaimName must contain a property name");
        this.rolesClaimName = rolesClaimName;
    }

    @Override
    public List<GrantedAuthority> claimsToGrantedAuthorities(Map<String, Object> oidcClaims) {
        List<String> groups;
        if (oidcClaims.get(this.rolesClaimName) instanceof String) {
            groups = new ArrayList<String>();
            groups.add(this.rolesClaimName);
        } else {
            ArrayList list = oidcClaims.getOrDefault(this.rolesClaimName, new ArrayList());
            if (!(list instanceof List)) {
                throw new InvalidRoleClaimsListException(String.format("Role claims in property [%s] are not a list", this.rolesClaimName));
            }
            groups = oidcClaims.getOrDefault(this.rolesClaimName, new ArrayList());
        }
        logger.debug("Extracted groups/roles {}", groups);
        try {
            List<GrantedAuthority> authorities = groups.stream().map(g -> new SimpleGrantedAuthority(g)).collect(Collectors.toList());
            return authorities;
        }
        catch (ClassCastException e) {
            throw new InvalidRoleClaimsListException(String.format("Role claims name in property [%s] contained non string values", this.rolesClaimName));
        }
    }
}

