/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.platform.sso.oidc.web;

import com.xebialabs.platform.sso.oidc.OpenIdConnectProperty;
import com.xebialabs.platform.sso.oidc.userdetails.OpenIdConnectUserDetails;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.util.Assert;

public class OpenIdLogoutSuccessHandler
implements LogoutSuccessHandler {
    private final String logoutUri;
    private static final Logger log = LoggerFactory.getLogger(OpenIdLogoutSuccessHandler.class);

    public OpenIdLogoutSuccessHandler(String logoutUri) {
        Assert.isTrue((boolean)this.createLogoutUri(logoutUri).isAbsolute(), (String)(logoutUri + " isn't a valid logout URL"));
        this.logoutUri = logoutUri;
    }

    private URIBuilder createLogoutUri(String logoutUri) {
        try {
            return new URIBuilder(logoutUri);
        }
        catch (URISyntaxException e) {
            log.warn("Cannot log out with uri: {}", (Object)logoutUri);
            return new URIBuilder();
        }
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        if (authentication == null) {
            log.warn("Cannot log out without authentication");
            return;
        }
        if (!(authentication.getDetails() instanceof OpenIdConnectUserDetails)) {
            log.warn("Cannot log out without OpenIdConnectUserDetails for authentication: {}", (Object)authentication);
            return;
        }
        OpenIdConnectUserDetails userDetails = (OpenIdConnectUserDetails)authentication.getDetails();
        try {
            URIBuilder logoutUriBuilder = this.createLogoutUri(this.logoutUri);
            response.sendRedirect(logoutUriBuilder.addParameter(OpenIdConnectProperty.ID_TOKEN_HINT.getPropertyName(), userDetails.getIdToken()).build().toString());
        }
        catch (URISyntaxException e) {
            log.warn("Cannot log out with uri: {}", (Object)this.logoutUri);
            response.sendError(500, "Access token is not valid");
        }
    }
}

