/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.platform.sso.oidc.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.platform.sso.oidc.OpenIdConnectProperty;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToGrantedAuthoritiesPolicy;
import com.xebialabs.platform.sso.oidc.policy.ClaimsToUserNamePolicy;
import com.xebialabs.platform.sso.oidc.userdetails.OpenIdConnectUserDetails;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.jwt.Jwt;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.jwt.crypto.sign.InvalidSignatureException;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.util.Assert;

public class OpenIdConnectFilter
extends AbstractAuthenticationProcessingFilter {
    private static final Logger log = LoggerFactory.getLogger(OpenIdConnectFilter.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final String audience;
    private final String issuer;
    private final OAuth2RestTemplate restTemplate;
    private final ClaimsToUserNamePolicy claimsToUserNamePolicy;
    private final ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy;
    private SignatureVerifier signatureVerifier;

    public OpenIdConnectFilter(String defaultFilterProcessesUrl, String audience, String issuer, OAuth2RestTemplate restTemplate, SignatureVerifier signatureVerifier, ClaimsToUserNamePolicy claimsToUserNamePolicy, ClaimsToGrantedAuthoritiesPolicy claimsToGrantedAuthoritiesPolicy) {
        super(defaultFilterProcessesUrl);
        Assert.hasText((String)audience, (String)"audience/clientId cannot be empty");
        Assert.hasText((String)issuer, (String)"issuer cannot be empty");
        this.audience = audience;
        this.issuer = issuer;
        this.restTemplate = restTemplate;
        this.claimsToGrantedAuthoritiesPolicy = claimsToGrantedAuthoritiesPolicy;
        this.claimsToUserNamePolicy = claimsToUserNamePolicy;
        this.signatureVerifier = signatureVerifier;
    }

    protected OAuth2AccessToken getAccessToken() {
        try {
            return this.restTemplate.getAccessToken();
        }
        catch (OAuth2Exception e) {
            throw new BadCredentialsException("Could not obtain access token", (Throwable)e);
        }
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        try {
            log.debug("Starting authentication attempt: getting OIDC access token");
            OAuth2AccessToken accessToken = this.getAccessToken();
            log.debug("Retrieving {} from access token", (Object)OpenIdConnectProperty.ID_TOKEN.getPropertyName());
            String idToken = accessToken.getAdditionalInformation().get(OpenIdConnectProperty.ID_TOKEN.getPropertyName()).toString();
            Jwt tokenDecoded = JwtHelper.decodeAndVerify((String)idToken, (SignatureVerifier)this.signatureVerifier);
            Map claims = (Map)this.objectMapper.readValue(tokenDecoded.getClaims(), Map.class);
            log.debug("Received claims: [{}]", (Object)claims);
            this.verifyTimestamps(claims);
            this.verifyAudience(claims);
            this.verifyIssuer(claims);
            String userName = this.claimsToUserNamePolicy.claimsToUserName(claims);
            log.debug("User name derived from claims: {}", (Object)userName);
            List<GrantedAuthority> authorities = this.claimsToGrantedAuthoritiesPolicy.claimsToGrantedAuthorities(claims);
            OpenIdConnectUserDetails user = new OpenIdConnectUserDetails(userName, claims, authorities, idToken);
            log.debug("User {} successfully authenticated via OIDC", (Object)user);
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)user, null, user.getAuthorities());
            token.setDetails((Object)user);
            return token;
        }
        catch (InvalidSignatureException e) {
            log.error("Invalid signature on JWT token. Is the property xl.security.auth.providers.oidc.publicKey in the configuration file configured properly?", (Throwable)e);
            throw new BadCredentialsException("Unable to verify the validity of the received JWT token", (Throwable)e);
        }
        catch (InvalidTokenException e) {
            throw new BadCredentialsException("Could not obtain user details from token", (Throwable)e);
        }
    }

    protected void verifyTimestamps(Map<String, Object> claims) {
        try {
            Number o = (Number)claims.get(OpenIdConnectProperty.EXPIRATION.getPropertyName());
            if (o == null) {
                throw new BadCredentialsException("Invalid OIDC access token: no '" + OpenIdConnectProperty.EXPIRATION.getPropertyName() + "' claim");
            }
            long exp = o.longValue();
            long now = System.currentTimeMillis() / 1000L;
            if (now >= exp) {
                log.error("Invalid OIDC access token: it has expired. exp={}, now={}. Check if system time is in sync, or if the expiry setting is too low", (Object)exp, (Object)now);
                throw new BadCredentialsException("OIDC access token has expired");
            }
        }
        catch (ClassCastException e) {
            throw new BadCredentialsException("Invalid OIDC access token it has a non numeric '" + OpenIdConnectProperty.EXPIRATION.getPropertyName() + "' claim");
        }
    }

    private void verifyIssuer(Map<String, Object> claims) {
        Object receivedIssuer = claims.get(OpenIdConnectProperty.ISSUER.getPropertyName());
        if (!this.issuer.equals(receivedIssuer)) {
            log.error("JWT token has wrong issuer. Is xl.security.auth.providers.oidc.issuer in the configuration file configured properly? Expected=[{}] actual=[{}]", (Object)this.issuer, receivedIssuer);
            throw new BadCredentialsException("Received JWT token is from wrong issuer");
        }
    }

    private void verifyAudience(Map<String, Object> claims) {
        Object receivedAudience = claims.get(OpenIdConnectProperty.AUDIENCE.getPropertyName());
        if (!this.audience.equals(receivedAudience)) {
            log.error("JWT token has wrong audience. Is xl.security.auth.providers.oidc.clientId in the configuration file configured properly? Expected=[{}] actual=[{}]", (Object)this.audience, receivedAudience);
            throw new BadCredentialsException("Received JWT token is for wrong audience");
        }
    }
}

