/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.platform.sso.crypto;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.springframework.security.jwt.crypto.sign.InvalidSignatureException;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;

public class RS256SignatureVerifier
implements SignatureVerifier {
    public static final String SIGNING_ALGORITHM = "SHA256withRSA";
    private final PublicKey publicKey;

    public RS256SignatureVerifier(String key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] der = Base64.getDecoder().decode(key);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(der);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        this.publicKey = kf.generatePublic(spec);
    }

    public void verify(byte[] content, byte[] signature) {
        try {
            Signature verifier = Signature.getInstance(SIGNING_ALGORITHM);
            verifier.initVerify(this.publicKey);
            verifier.update(content);
            if (!verifier.verify(signature)) {
                throw new InvalidSignatureException("JWT Token failed RS256 signature verification");
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    public String algorithm() {
        return "RS256";
    }
}

