import time
from com.xebialabs.deployit.engine.api.execution import TaskExecutionState

from asserts import *


def assert_step_state(task_id, step_id, expected_state):
    step = read_step(task_id, step_id)
    assert_not_none(step)
    assert_equals(expected_state, step.state)


def assert_task_state(task_id, expected_state):
    task = read_task(task_id)
    assert_not_none(task)
    assert_equals(expected_state, task.state)


def wait_for_task_state(task_id, expected_state, retry_count=20, sleep_time=1):
    retries = 1
    task = read_task(task_id)
    while task.state != expected_state:
        retries = retries + 1
        if retries > retry_count or has_task_failed(task):
            raise AssertionError(
                "Error waiting for task state of task: " + task_id + ". Expected state: " + expected_state.name() + " current: " + task.state.name())
        time.sleep(sleep_time)
        task = read_task(task_id)


def wait_for_step_state(task_id, step_id, expected_state, retry_count=20, sleep_time=1):
    retries = 1
    step = read_step(task_id, step_id)
    while step.state != expected_state:
        retries = retries + 1
        if retries > retry_count:
            raise AssertionError(
                "Error waiting for step state of task: " + task_id + ", step id: " + step_id + ". Expected state: " + expected_state.name() + " current: " + step.state.name())
        time.sleep(sleep_time)
        step = read_step(task_id, step_id)


def has_task_failed(task):
    return 'FAILED' in task.state.name()


def schedule_and_wait(task_id, date):
    schedule_task(task_id, date)
    wait_for_task_state(task_id, TaskExecutionState.SCHEDULED)


def abort_and_wait(task_id):
    abort_task(task_id)
    wait_for_task_state(task_id, TaskExecutionState.ABORTED)


def stop_and_wait(task_id):
    stop_task(task_id)
    wait_for_task_state(task_id, TaskExecutionState.STOPPED)


def read_task(task_id):
    return task2.get(task_id)


def read_step(task_id, step_id):
    return task2.step(task_id, step_id)


def start_task(task_id):
    task2.start(task_id)


def abort_task(task_id):
    task2.abort(task_id)


def schedule_task(task_id, date):
    task2.schedule(task_id, date)


def stop_task(task_id):
    task2.stop(task_id)


def archive_task(task_id):
    task2.archive(task_id)


def cancel_task(task_id):
    task2.cancel(task_id)

def add_pause(task_id, step_path):
    task2.addPause(task_id, step_path)

