
def assert_none(object):
    if object is not None:
        raise AssertionError("expected None but is ", object)


def assert_not_none(object):
    if object is None:
        raise AssertionError("expected not None but is None")


def fail(message):
    raise AssertionError(message)


def assert_true(condition, message=None):
    assert_equals(True, condition, message)


def assert_false(condition, message=None):
    assert_equals(False, condition, message)


def assert_equals(expected, actual, message=None):
    msg = "Expected "
    if message is not None:
        msg = message + ": " + msg
    if expected != actual:
        raise AssertionError(msg + str(expected) + " but was " + str(actual))


def assert_not_equals(expected, actual, message=None):
    msg = "Expected non equality of "
    if message is not None:
        msg = message + ": " + msg
    if expected == actual:
        raise AssertionError(msg + str(expected) + " and " + str(actual))



def should_fail(msg, operation, *args):
    try:
        operation(*args)
    except:
        pass
    else:
        fail(msg)


