package com.xebialabs.xlplatform.tests.utils

import com.typesafe.scalalogging.LazyLogging
import com.xebialabs.overthere.{CmdLine, OverthereConnection, OverthereFile}

trait OverthereSupport extends LazyLogging {

  type ExitCodeAssertion = (Int) => Unit
  val shouldEqualZero: ExitCodeAssertion = exitCode => require(exitCode == 0, s"Failed with NON Zero exit code $exitCode")
  val shouldNotEqualZero: ExitCodeAssertion = exitCode => require(exitCode != 0, "Command should have failed but it succeeded with ZERO exit code")

  def workingDirectory(implicit remote: OverthereConnection): OverthereFile = {
    val workDir = remote.getTempFile("working.dir")
    logger.info(s"Creating remote working dir ${workDir.getPath}")
    workDir.mkdirs()
    remote.setWorkingDirectory(workDir)
    workDir
  }

  def uploadTo(destinationDirectory: OverthereFile, srcFile: OverthereFile) = {
    val result = destinationDirectory.getFile(srcFile.getName)
    logger.info(s"Copying ${srcFile.getPath} into remote ${result.getPath}")
    srcFile.copyTo(result)
    srcFile.getConnection.close()
    result
  }

  def executeCommand(command: String, exitCodeAssertion: ExitCodeAssertion = shouldEqualZero)(implicit remote: OverthereConnection) = {
    logger.info(s"Executing remotely: $command")
    val line = new CmdLine()
    line.addRaw(command)
    exitCodeAssertion(remote.execute(line))
  }
}
