package com.xebialabs.xlplatform.tests

import java.io.{File, FilenameFilter}
import java.nio.file.{Files, Path}

import scala.util.matching.Regex
import scala.collection.mutable.ListBuffer
import scala.language.implicitConversions
import scala.jdk.CollectionConverters._

package object runner {

  object Implicits {

    implicit def path2File(path: Path): File = path.toFile

    implicit def file2Path(file: File): Path = file.toPath

    implicit class PathUtils(val realPath: Path) extends AnyVal {

      def filter(regex: Regex): FilenameFilter = (_: File, name: String) => regex.findFirstIn(name).nonEmpty

      def toNilIfNotExists: Seq[Path] = if (realPath.exists) Seq(realPath) else Nil

      def lines: Seq[String] = Files.readAllLines(realPath).asScala.toSeq

      def /(rest: String): Path = realPath.resolve(rest)

      def path: String = realPath.toFile.getPath

      def name: String = realPath.toFile.getName

      def descendents(regex: Regex, listBuffer: ListBuffer[Path]): Unit = {
        if (realPath.toFile.isDirectory) {
          realPath.toFile.listFiles().foreach(file2Path(_).descendents(regex, listBuffer))
        } else {
          if (regex.findFirstIn(name).isDefined) {
            listBuffer += realPath
          }
        }
      }

      def **(regex: Regex): Seq[Path] = {
        val buffer = new ListBuffer[Path]
        descendents(regex, buffer)
        buffer.toList
      }
    }
  }

}
