package com.xebialabs.xlplatform.tests.runner

import com.typesafe.config.{Config, ConfigFactory}

class TestConfig(config: Config) {

  private lazy val cfg = ConfigFactory.load(config).getConfig("xl.test")

  object cli {
    lazy val cliCfg: Config = cfg.getConfig("cli")
    lazy val serverHost: String = cliCfg.getString("server.host")
    lazy val serverPort: Int = cliCfg.getInt("server.port")
    lazy val username: String = cliCfg.getString("username")
    lazy val password: String = cliCfg.getString("password")
    lazy val exposeProxies: Boolean = cliCfg.getBoolean("exposeProxies")
    lazy val socketTimeout: Int = cliCfg.getInt("socketTimeout")
  }

  object runner {
    lazy val runnerCfg: Config = cfg.getConfig("runner")
    lazy val baseDirectory: String = runnerCfg.getString("baseDirectory")
    lazy val scriptFileNameRegex: String = runnerCfg.getString("scriptFileNameRegex")
  }

}
