package com.xebialabs.xlplatform.tests.runner

import javax.script.ScriptContext

import com.typesafe.scalalogging.LazyLogging
import com.xebialabs.deployit.cli.{Cli, CliOptions, Interpreter}

trait CliScriptRunner extends LazyLogging {

  val testConfig: TestConfig

  private lazy val cli: Cli = {
    val options: CliOptions = new CliOptions
    options.setHost(testConfig.cli.serverHost)
    options.setPort(testConfig.cli.serverPort)
    options.setExposeProxies(testConfig.cli.exposeProxies)
    options.setUsername(testConfig.cli.username)
    options.setPassword(testConfig.cli.password)
    new Cli(options)
  }

  def newInterpreter = {
    val interpreter = cli.getNewInterpreter
    interpreter.getScriptContext.setAttribute("_global_integration_test_port", testConfig.cli.serverPort, ScriptContext.ENGINE_SCOPE)
    interpreter
  }

  def executeScriptByPath(path: String)(implicit interpreter: Interpreter) = {
    try {
      interpreter.evaluateFile(path)
    } catch {
      case e: Exception =>
        logger.error("Exception while executing script " + path, e)
        throw new RuntimeException(e)
    }
  }
}
