package com.xebialabs.xlplatform.tests.runner

import com.typesafe.config.{ConfigFactory, Config}

class TestConfig(config: Config) {

  private lazy val cfg = ConfigFactory.load(config).getConfig("xl.test")

  object cli {
    lazy val cliCfg = cfg.getConfig("cli")
    lazy val serverHost = cliCfg.getString("server.host")
    lazy val serverPort = cliCfg.getInt("server.port")
    lazy val username = cliCfg.getString("username")
    lazy val password = cliCfg.getString("password")
    lazy val exposeProxies = cliCfg.getBoolean("exposeProxies")
  }

  object runner {
    lazy val runnerCfg = cfg.getConfig("runner")
    lazy val baseDirectory = runnerCfg.getString("baseDirectory")
    lazy val scriptFileNameRegex = runnerCfg.getString("scriptFileNameRegex")
  }

}
