package com.xebialabs.deployit.engine.tasker;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.api.execution.TaskPackageDependency;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.plugin.api.udm.OnTaskFailurePolicy;
import com.xebialabs.deployit.plugin.api.udm.OnTaskSuccessPolicy;
import com.xebialabs.deployit.repository.WorkDir;
import org.springframework.security.core.Authentication;

import java.io.Serializable;
import java.util.*;


public class TaskSpecification implements Serializable {
    private final String description;
    private final Authentication owner;
    private final PhaseContainer block;
    private final Map<String, String> metadata = new HashMap<>();
    private List<ExecutionStateListener> listeners = new ArrayList<>();
    private final WorkDir workDir;
    private final String id;
    private TaskInspectionContext inspectionContext;
    private boolean recoverable;
    private boolean archiveable;
    private boolean rollback;
    private final OnTaskSuccessPolicy onSuccessPolicy;
    private final OnTaskFailurePolicy onFailurePolicy ;
    private List<TaskPackageDependency> packageDependencies = new ArrayList<>();

    public TaskSpecification(String description, Authentication owner, WorkDir workDir, PhaseContainer block) {
        this(description, owner, workDir, block, OnTaskSuccessPolicy.NOOP, OnTaskFailurePolicy.NOOP);
    }

    public TaskSpecification(String description, Authentication owner, WorkDir workDir, PhaseContainer block, OnTaskSuccessPolicy onSuccessPolicy, OnTaskFailurePolicy onFailurePolicy) {
        this(description, owner, workDir, block, null, true, true, onSuccessPolicy, onFailurePolicy);
    }

    public TaskSpecification(String id, String description, Authentication owner, WorkDir workDir, PhaseContainer block) {
        this(id, description, owner, workDir, block, null, true, true, false, OnTaskSuccessPolicy.NOOP);
    }

    public TaskSpecification(String description, Authentication owner, WorkDir workDir, PhaseContainer block, TaskInspectionContext inspectionContext) {
        this(description, owner, workDir, block, inspectionContext, true);
    }

    public TaskSpecification(String description, Authentication owner, WorkDir workDir, PhaseContainer block, TaskInspectionContext inspectionContext, boolean recoverable) {
        this(description, owner, workDir, block, inspectionContext, recoverable, true);
    }

    public TaskSpecification(String description, Authentication owner, WorkDir workDir, PhaseContainer block, TaskInspectionContext inspectionContext, boolean recoverable, boolean archiveable) {
        this(description, owner, workDir, block, inspectionContext, recoverable, archiveable, OnTaskSuccessPolicy.NOOP, OnTaskFailurePolicy.NOOP);
    }

    public TaskSpecification(String description, Authentication owner, WorkDir workDir, PhaseContainer block, TaskInspectionContext inspectionContext, boolean recoverable, boolean archiveable, OnTaskSuccessPolicy onSuccessPolicy) {
        this(UUID.randomUUID().toString(), description, owner, workDir, block, inspectionContext, recoverable, archiveable, false, onSuccessPolicy);
    }

    public TaskSpecification(String description, Authentication owner, WorkDir workDir, PhaseContainer block, TaskInspectionContext inspectionContext, boolean recoverable, boolean archiveable, OnTaskSuccessPolicy onSuccessPolicy, OnTaskFailurePolicy onFailurePolicy) {
        this(UUID.randomUUID().toString(), description, owner, workDir, block, inspectionContext, recoverable, archiveable, false, onSuccessPolicy, onFailurePolicy);
    }

    public TaskSpecification(String id, String description, Authentication owner, WorkDir workDir, PhaseContainer block, TaskInspectionContext inspectionContext, boolean recoverable, boolean archiveable) {
        this(id, description, owner, workDir, block, inspectionContext, recoverable, archiveable, false, OnTaskSuccessPolicy.NOOP);
    }

    public TaskSpecification(String id, String description, Authentication owner, WorkDir workDir, PhaseContainer block, TaskInspectionContext inspectionContext, boolean recoverable, boolean archiveable, boolean rollback, OnTaskSuccessPolicy onSuccessPolicy) {
        this(id, description, owner, workDir, block, inspectionContext, recoverable, archiveable, rollback, onSuccessPolicy, OnTaskFailurePolicy.NOOP);
    }

    public TaskSpecification(String id, String description, Authentication owner, WorkDir workDir, PhaseContainer block, TaskInspectionContext inspectionContext, boolean recoverable, boolean archiveable, boolean rollback, OnTaskSuccessPolicy onSuccessPolicy, OnTaskFailurePolicy onFailurePolicy) {
        Checks.checkNotNull(workDir, "WorkDir cannot be null");
        this.id = id;
        this.description = description;
        this.owner = owner;
        this.block = block;
        this.inspectionContext = inspectionContext;
        this.workDir = workDir;
        this.recoverable = recoverable;
        this.archiveable = archiveable;
        this.rollback = rollback;
        this.onSuccessPolicy = onSuccessPolicy;
        this.onFailurePolicy = onFailurePolicy;
    }

    public String getId() {
        return id;
    }

    public String getDescription() {
        return description;
    }

    // Ugly casting ;-)
    @SuppressWarnings("unchecked")
    public List<TaskStep> getSteps() {
        return (List<TaskStep>) ((List) block.getStepList());
    }

    public PhaseContainer getBlock() {
        return block;
    }

    public Authentication getOwner() {
        return owner;
    }

    public Map<String, String> getMetadata() {
        return metadata;
    }

    public List<ExecutionStateListener> getListeners() {
        return listeners;
    }

    public TaskInspectionContext getInspectionContext() {
        return inspectionContext;
    }

    public WorkDir getWorkDir() {
        return workDir;
    }

    public boolean isRecoverable() {
        return recoverable;
    }

    public boolean isArchiveable() {
        return archiveable;
    }

    public boolean isRollback() {
        return rollback;
    }

    public OnTaskSuccessPolicy getOnSuccessPolicy() {
        return onSuccessPolicy == null ? OnTaskSuccessPolicy.NOOP : onSuccessPolicy;
    }

    public OnTaskFailurePolicy getOnFailurePolicy() {
        return onFailurePolicy == null ? OnTaskFailurePolicy.NOOP : onFailurePolicy;
    }

    public List<TaskPackageDependency> getPackageDependencies() {
        return packageDependencies;
    }
}
