package com.xebialabs.deployit.engine

import akka.actor.{ActorContext, ActorRef, Props}

package object tasker {
  type Cache[A, B] = collection.mutable.Map[A, B]
  val Cache = collection.mutable.Map

  type TaskId = String
  type BlockId = String
  type Description = String
  type StepId = String
  val stateManagementDispatcher = "xl.task.dispatchers.state-management-dispatcher"
  val stateEventListenerDispatcher = "xl.task.dispatchers.state-event-listener-dispatcher"
  val stepDispatcher = "xl.task.dispatchers.step-dispatcher"
  val archiveDispatcher = "xl.task.dispatchers.archive-dispatcher"

  trait ActorCreationSupport {
    def createChild(props: Props, name: String): ActorRef
  }

  trait ActorContextCreationSupport extends ActorCreationSupport {
    def context: ActorContext
    def createChild(props: Props, name: String): ActorRef = context.actorOf(props, name)
    def createChild(props: Props): ActorRef = context.actorOf(props)
  }
}
