package com.xebialabs.deployit.engine.tasker;

import java.util.List;

import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import org.joda.time.DateTime;

import org.springframework.security.core.Authentication;

public interface IEngine {
    String register(TaskSpecification spec);

    void prepareRollback(String taskid, TaskSpecification rollbackSpec);

    Task retrieve(String taskid);

    void execute(String taskid);

    void schedule(String taskid, DateTime scheduleAt);

    void abort(String taskid);

    void stop(String taskid);

    default void cancel(String taskid) {
        cancel(taskid, false);
    }

    void cancel(String taskid, boolean force);

    @Deprecated
    void skipSteps(String taskid, List<Integer> stepNrs);

    @Deprecated
    void unskipSteps(String taskid, List<Integer> stepNrs);

    void skipStepPaths(String taskid, List<BlockPath> stepNrs);

    void unskipStepPaths(String taskid, List<BlockPath> stepNrs);

    void addPauseStep(String taskid, BlockPath position);

    @Deprecated
    void addPauseStep(String taskid, Integer position);

    List<TaskWithBlock> getAllIncompleteTasks(FetchMode fetchMode);

    void archive(String taskid);

    Task assign(String taskid, Authentication owner);

    List<String> reregisterGhostTasks();
}
