/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import akka.actor.ActorNotFound;
import akka.actor.ActorPath;
import akka.actor.ActorPath$;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSelection$;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Props;
import akka.actor.Props$;
import akka.actor.ScalaActorSelection;
import akka.pattern.AskableActorRef$;
import akka.pattern.AskableActorSelection$;
import akka.util.Timeout;
import com.github.nscala_time.time.Imports$;
import com.github.nscala_time.time.RichDateTime$;
import com.github.nscala_time.time.RichReadableInstant$;
import com.github.nscala_time.time.RichReadableInterval$;
import com.xebialabs.deployit.engine.api.distribution.TaskExecutionWorkerRepository;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.tasker.BlockPath;
import com.xebialabs.deployit.engine.tasker.BlockPath$Root$;
import com.xebialabs.deployit.engine.tasker.IEngine;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskFinalizer;
import com.xebialabs.deployit.engine.tasker.TaskManagingActor;
import com.xebialabs.deployit.engine.tasker.TaskNotFoundException;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.engine.tasker.TaskerException;
import com.xebialabs.deployit.engine.tasker.distribution.ChunkReceivingForwarder;
import com.xebialabs.deployit.engine.tasker.distribution.ChunkSendingForwarder;
import com.xebialabs.deployit.engine.tasker.distribution.NoWorkersException;
import com.xebialabs.deployit.engine.tasker.distribution.ReRegisterGhostTasksAggregator;
import com.xebialabs.deployit.engine.tasker.distribution.TaskDistributor;
import com.xebialabs.deployit.engine.tasker.distribution.TaskDistributor$;
import com.xebialabs.deployit.engine.tasker.distribution.TaskDistributor$messages$CreateTaskActor$;
import com.xebialabs.deployit.engine.tasker.distribution.TasksManager$;
import com.xebialabs.deployit.engine.tasker.distribution.WorkerManager;
import com.xebialabs.deployit.engine.tasker.distribution.WorkerManager$messages$NoWorkersError$;
import com.xebialabs.deployit.engine.tasker.messages.Abort;
import com.xebialabs.deployit.engine.tasker.messages.AddPauseStep;
import com.xebialabs.deployit.engine.tasker.messages.Enqueue;
import com.xebialabs.deployit.engine.tasker.messages.ModifySteps;
import com.xebialabs.deployit.engine.tasker.messages.PathsNotFound;
import com.xebialabs.deployit.engine.tasker.messages.Registered;
import com.xebialabs.deployit.engine.tasker.messages.RunMode$;
import com.xebialabs.deployit.engine.tasker.messages.SkipSteps;
import com.xebialabs.deployit.engine.tasker.messages.StepModificationError;
import com.xebialabs.deployit.engine.tasker.messages.Stop;
import com.xebialabs.deployit.engine.tasker.messages.UnSkipSteps;
import com.xebialabs.deployit.engine.tasker.repository.ActiveTask;
import com.xebialabs.deployit.engine.tasker.repository.ActiveTaskRepository;
import com.xebialabs.xlplatform.settings.CommonSettings;
import com.xebialabs.xlplatform.settings.CommonSettings$;
import com.xebialabs.xlplatform.settings.TaskerSettings;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeoutException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.slf4j.Marker;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\r\u0005g\u0001B\u001a5\u0001}B\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\t7\u0002\u0011\t\u0011)A\u00059\"AA\r\u0001B\u0001B\u0003%Q\r\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003o\u0011!\t\bA!A!\u0002\u0013\u0011\b\"B;\u0001\t\u00031\bbB?\u0001\u0005\u0004%IA \u0005\b\u0003\u001f\u0001\u0001\u0015!\u0003\u0000\u0011%\t\t\u0002\u0001b\u0001\n\u0013\t\u0019\u0002\u0003\u0005\u0002\u001c\u0001\u0001\u000b\u0011BA\u000b\u0011%\ti\u0002\u0001b\u0001\n\u0013\ty\u0002C\u0004\u0002\"\u0001\u0001\u000b\u0011\u00028\t\u000f\u0005\r\u0002\u0001\"\u0011\u0002&!I\u0011q\u000b\u0001\u0012\u0002\u0013\u0005\u0011\u0011\f\u0005\b\u0003_\u0002A\u0011IA9\u0011\u001d\t)\b\u0001C!\u0003oB\u0001\"!%\u0001A\u0013%\u00111\u0013\u0005\b\u0003c\u0003A\u0011BAZ\u0011!\t9\r\u0001Q\u0005\n\u0005%\u0007bBAh\u0001\u0011\u0005\u0013\u0011\u001b\u0005\t\u0003/\u0004\u0001\u0015\"\u0003\u0002Z\"9\u0011q\u001c\u0001\u0005B\u0005\u0005\bbBAp\u0001\u0011\u0005\u0013\u0011\u001e\u0005\b\u0003/\u0004A\u0011IAx\u0011\u001d\t\t\n\u0001C!\u0003oDq!!@\u0001\t\u0003\ny\u0010C\u0004\u0003\u0004\u0001!\tE!\u0002\t\u000f\t%\u0001\u0001\"\u0011\u0003\f!9!q\u0002\u0001\u0005B\tE\u0001b\u0002B\u000e\u0001\u0011\u0005#Q\u0004\u0005\b\u0005{\u0001A\u0011\u0002B \u0011!\u0011Y\u0005\u0001C\u0001i\t5\u0003\u0002\u0003B)\u0001\u0011\u0005AGa\u0015\t\u000f\t]\u0003\u0001\"\u0003\u0003Z!9!1\u000e\u0001\u0005\n\t5\u0004b\u0002BQ\u0001\u0011%!1\u0015\u0005\b\u0005c\u0003A\u0011\u0001BZ\u0011\u001d\u00119\u000f\u0001C!\u0005SDqA!>\u0001\t\u0003\u00129\u0010C\u0004\u0003\u0000\u0002!Ia!\u0001\t\u0011\r%\u0001\u0001)C\u0005\u0007\u0017A\u0011ba\u0007\u0001#\u0003%Ia!\b\t\u000f\r\u0005\u0002\u0001\"\u0011\u0004$!I1Q\b\u0001\u0012\u0002\u0013\u00051q\b\u0005\b\u0007\u0007\u0002A\u0011IB#\u0011!\u0019I\u0005\u0001Q\u0005\n\r-\u0003\u0002CB0\u0001\u0001&Ia!\u0019\t\u0011\r}\u0003\u0001)C\u0005\u0007gB\u0001b!\"\u0001A\u0013%1q\u0011\u0005\b\u0007k\u0003A\u0011AB\\\u0005M!\u0016m]6Fq\u0016\u001cW\u000f^5p]\u0016sw-\u001b8f\u0015\t)d'\u0001\u0004uCN\\WM\u001d\u0006\u0003oa\na!\u001a8hS:,'BA\u001d;\u0003!!W\r\u001d7ps&$(BA\u001e=\u0003%AXMY5bY\u0006\u00147OC\u0001>\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001\u0001\t\u0013'\u0011\u0005\u00053U\"\u0001\"\u000b\u0005\r#\u0015\u0001\u00027b]\u001eT\u0011!R\u0001\u0005U\u00064\u0018-\u0003\u0002H\u0005\n1qJ\u00196fGR\u0004\"!\u0013&\u000e\u0003QJ!a\u0013\u001b\u0003\u000f%+enZ5oKB\u0011QJU\u0007\u0002\u001d*\u0011q\nU\u0001\u0006g24GG\u001b\u0006\u0002#\u0006AqM]5{u2,G-\u0003\u0002T\u001d\n9Aj\\4hS:<\u0017A\u0004;bg.\u0014V\r]8tSR|'/\u001f\t\u0003-fk\u0011a\u0016\u0006\u00031R\n!B]3q_NLGo\u001c:z\u0013\tQvK\u0001\u000bBGRLg/\u001a+bg.\u0014V\r]8tSR|'/_\u0001\u0011o>\u00148.\u001a:SKB|7/\u001b;pef\u0004\"!\u00182\u000e\u0003yS!a\u00181\u0002\u0019\u0011L7\u000f\u001e:jEV$\u0018n\u001c8\u000b\u0005\u00054\u0014aA1qS&\u00111M\u0018\u0002\u001e)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8X_J\\WM\u001d*fa>\u001c\u0018\u000e^8ss\u000611/_:uK6\u0004\"AZ6\u000e\u0003\u001dT!\u0001[5\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003)\fA!Y6lC&\u0011An\u001a\u0002\f\u0003\u000e$xN]*zgR,W.A\u0007x_J\\WM]'b]\u0006<WM\u001d\t\u0003M>L!\u0001]4\u0003\u0011\u0005\u001bGo\u001c:SK\u001a\fQ\u0002^1tW\u001aKg.\u00197ju\u0016\u0014\bCA%t\u0013\t!HGA\u0007UCN\\g)\u001b8bY&TXM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\r]D\u0018P_>}!\tI\u0005\u0001C\u0003U\r\u0001\u0007Q\u000bC\u0003\\\r\u0001\u0007A\fC\u0003e\r\u0001\u0007Q\rC\u0003n\r\u0001\u0007a\u000eC\u0003r\r\u0001\u0007!/\u0001\bd_6lwN\\*fiRLgnZ:\u0016\u0003}\u0004B!!\u0001\u0002\f5\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0005tKR$\u0018N\\4t\u0015\r\tIAO\u0001\u000bq2\u0004H.\u0019;g_Jl\u0017\u0002BA\u0007\u0003\u0007\u0011abQ8n[>t7+\u001a;uS:<7/A\bd_6lwN\\*fiRLgnZ:!\u00039!\u0018m]6feN+G\u000f^5oON,\"!!\u0006\u0011\t\u0005\u0005\u0011qC\u0005\u0005\u00033\t\u0019A\u0001\bUCN\\WM]*fiRLgnZ:\u0002\u001fQ\f7o[3s'\u0016$H/\u001b8hg\u0002\n1\u0002Z5tiJL'-\u001e;peV\ta.\u0001\u0007eSN$(/\u001b2vi>\u0014\b%\u0001\u0004dC:\u001cW\r\u001c\u000b\u0007\u0003O\t\u0019$!\u0014\u0011\t\u0005%\u0012qF\u0007\u0003\u0003WQ!!!\f\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005E\u00121\u0006\u0002\u0005+:LG\u000fC\u0004\u000265\u0001\r!a\u000e\u0002\rQ\f7o[5e!\u0011\tI$a\u0012\u000f\t\u0005m\u00121\t\t\u0005\u0003{\tY#\u0004\u0002\u0002@)\u0019\u0011\u0011\t \u0002\rq\u0012xn\u001c;?\u0013\u0011\t)%a\u000b\u0002\rA\u0013X\rZ3g\u0013\u0011\tI%a\u0013\u0003\rM#(/\u001b8h\u0015\u0011\t)%a\u000b\t\u0013\u0005=S\u0002%AA\u0002\u0005E\u0013!\u00024pe\u000e,\u0007\u0003BA\u0015\u0003'JA!!\u0016\u0002,\t9!i\\8mK\u0006t\u0017\u0001E2b]\u000e,G\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\tYF\u000b\u0003\u0002R\u0005u3FAA0!\u0011\t\t'a\u001b\u000e\u0005\u0005\r$\u0002BA3\u0003O\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\u0005%\u00141F\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA7\u0003G\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u001d\t'o\u00195jm\u0016$B!a\n\u0002t!9\u0011QG\bA\u0002\u0005]\u0012!C:lSB\u001cF/\u001a9t)\u0019\t9#!\u001f\u0002|!9\u0011Q\u0007\tA\u0002\u0005]\u0002bBA?!\u0001\u0007\u0011qP\u0001\bgR,\u0007O\u0014:t!\u0019\t\t)a\"\u0002\f6\u0011\u00111\u0011\u0006\u0004\u0003\u000b#\u0015\u0001B;uS2LA!!#\u0002\u0004\n!A*[:u!\r\t\u0015QR\u0005\u0004\u0003\u001f\u0013%aB%oi\u0016<WM]\u0001\u000eg.L\u0007o\u0015;faB\u000bG\u000f[:\u0015\r\u0005\u001d\u0012QSAL\u0011\u001d\t)$\u0005a\u0001\u0003oAq!! \u0012\u0001\u0004\tI\n\u0005\u0004\u0002\u001c\u0006\u0015\u00161\u0016\b\u0005\u0003;\u000b\tK\u0004\u0003\u0002>\u0005}\u0015BAA\u0017\u0013\u0011\t\u0019+a\u000b\u0002\u000fA\f7m[1hK&!\u0011qUAU\u0005\r\u0019V-\u001d\u0006\u0005\u0003G\u000bY\u0003E\u0002J\u0003[K1!a,5\u0005%\u0011En\\2l!\u0006$\b.\u0001\u0006nC:\fw-Z*uKB$b!a\n\u00026\u0006]\u0006bBA\u001b%\u0001\u0007\u0011q\u0007\u0005\b\u0003s\u0013\u0002\u0019AA^\u0003\u001diWm]:bO\u0016\u0004B!!0\u0002D6\u0011\u0011q\u0018\u0006\u0004\u0003\u0003$\u0014\u0001C7fgN\fw-Z:\n\t\u0005\u0015\u0017q\u0018\u0002\f\u001b>$\u0017NZ=Ti\u0016\u00048/A\u0007j]R\u0014$\t\\8dWB\u000bG\u000f\u001b\u000b\u0005\u0003W\u000bY\rC\u0004\u0002NN\u0001\r!a#\u0002\u0017=dG\rU8tSRLwN\\\u0001\fk:\u001c8.\u001b9Ti\u0016\u00048\u000f\u0006\u0004\u0002(\u0005M\u0017Q\u001b\u0005\b\u0003k!\u0002\u0019AA\u001c\u0011\u001d\ti\b\u0006a\u0001\u0003\u007f\nq\"\u001e8tW&\u00048\u000b^3q!\u0006$\bn\u001d\u000b\u0007\u0003O\tY.!8\t\u000f\u0005UR\u00031\u0001\u00028!9\u0011QP\u000bA\u0002\u0005e\u0015\u0001D1eIB\u000bWo]3Ti\u0016\u0004HCBA\u0014\u0003G\f)\u000fC\u0004\u00026Y\u0001\r!a\u000e\t\u000f\u0005\u001dh\u00031\u0001\u0002\f\u0006A\u0001o\\:ji&|g\u000e\u0006\u0004\u0002(\u0005-\u0018Q\u001e\u0005\b\u0003k9\u0002\u0019AA\u001c\u0011\u001d\t9o\u0006a\u0001\u0003W#b!a\n\u0002r\u0006M\bbBA\u001b1\u0001\u0007\u0011q\u0007\u0005\b\u0003{B\u0002\u0019AA{!\u0019\t\t)a\"\u0002,R1\u0011qEA}\u0003wDq!!\u000e\u001a\u0001\u0004\t9\u0004C\u0004\u0002~e\u0001\r!!>\u0002\tM$x\u000e\u001d\u000b\u0005\u0003O\u0011\t\u0001C\u0004\u00026i\u0001\r!a\u000e\u0002\u000b\u0005\u0014wN\u001d;\u0015\t\u0005\u001d\"q\u0001\u0005\b\u0003kY\u0002\u0019AA\u001c\u0003\u001d)\u00070Z2vi\u0016$B!a\n\u0003\u000e!9\u0011Q\u0007\u000fA\u0002\u0005]\u0012\u0001\u0003:fiJLWM^3\u0015\t\tM!\u0011\u0004\t\u0004\u0013\nU\u0011b\u0001B\fi\t!A+Y:l\u0011\u001d\t)$\ba\u0001\u0003o\ta!Y:tS\u001etGC\u0002B\n\u0005?\u0011\t\u0003C\u0004\u00026y\u0001\r!a\u000e\t\u000f\t\rb\u00041\u0001\u0003&\u0005)qn\u001e8feB!!q\u0005B\u001d\u001b\t\u0011IC\u0003\u0003\u0003,\t5\u0012\u0001B2pe\u0016TAAa\f\u00032\u0005A1/Z2ve&$\u0018P\u0003\u0003\u00034\tU\u0012aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\t]\u0012aA8sO&!!1\bB\u0015\u00059\tU\u000f\u001e5f]RL7-\u0019;j_:\fQb\u00195v].\u0014VmY3jm\u0016\u0014Hc\u00018\u0003B!9!1I\u0010A\u0002\t\u0015\u0013A\u00029be\u0016tG\u000fE\u0002g\u0005\u000fJ1A!\u0013h\u00059\t5\r^8s'\u0016dWm\u0019;j_:\fq\u0002\\8pWV\u0004H+Y:l\u0003\u000e$xN\u001d\u000b\u0005\u0005\u000b\u0012y\u0005C\u0004\u00026\u0001\u0002\r!a\u000e\u0002+1|wn[;q)\u0006\u001c8.Q2u_J\u0004\u0016M]3oiR!!Q\tB+\u0011\u001d\t)$\ta\u0001\u0003o\t!dZ3u\u0003\u000e$xN\u001d)bi\"4%o\\7SKB|7/\u001b;pef$BAa\u0017\u0003hA1\u0011\u0011\u0006B/\u0005CJAAa\u0018\u0002,\t1q\n\u001d;j_:\u00042A\u001aB2\u0013\r\u0011)g\u001a\u0002\n\u0003\u000e$xN\u001d)bi\"DqA!\u001b#\u0001\u0004\t9$\u0001\u0004uCN\\\u0017\nZ\u0001\u0014i\u0006\u001c8NT8u\r>,h\u000eZ(o\u000bJ\u0014xN]\u000b\u0005\u0005_\u0012\t\t\u0006\u0003\u0003r\tM\u0005\u0003CA\u0015\u0005g\u00129H! \n\t\tU\u00141\u0006\u0002\u0010!\u0006\u0014H/[1m\rVt7\r^5p]B!\u00111\u0014B=\u0013\u0011\u0011Y(!+\u0003\u0013QC'o\\<bE2,\u0007\u0003\u0002B@\u0005\u0003c\u0001\u0001B\u0004\u0003\u0004\u000e\u0012\rA!\"\u0003\u0003Q\u000bBAa\"\u0003\u000eB!\u0011\u0011\u0006BE\u0013\u0011\u0011Y)a\u000b\u0003\u000f9{G\u000f[5oOB!\u0011\u0011\u0006BH\u0013\u0011\u0011\t*a\u000b\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003j\r\u0002\rA!&\u0011\t\t]%1\u0014\b\u0004\u0013\ne\u0015bAARi%!!Q\u0014BP\u0005\u0019!\u0016m]6JI*\u0019\u00111\u0015\u001b\u0002+Q\f7o\u001b(pi\u001a{WO\u001c3Fq\u000e,\u0007\u000f^5p]V!!Q\u0015BX)\u0011\u00119K!,\u0011\u0007%\u0013I+C\u0002\u0003,R\u0012Q\u0003V1tW:{GOR8v]\u0012,\u0005pY3qi&|g\u000eC\u0004\u0003j\u0011\u0002\rA!&\u0005\u000f\t\rEE1\u0001\u0003\u0006\u0006A1o\u00195fIVdW\r\u0006\u0004\u0002(\tU&q\u0017\u0005\b\u0003k)\u0003\u0019AA\u001c\u0011\u001d\u0011I,\na\u0001\u0005w\u000b!b]2iK\u0012,H.Z!u!\u0011\u0011iLa8\u000f\t\t}&\u0011\u001c\b\u0005\u0005\u0003\u0014\u0019N\u0004\u0003\u0003D\n5g\u0002\u0002Bc\u0005\u0013tA!!\u0010\u0003H&\tQ(C\u0002\u0003Lr\naaZ5uQV\u0014\u0017\u0002\u0002Bh\u0005#\f1B\\:dC2\fw\f^5nK*\u0019!1\u001a\u001f\n\t\tU'q[\u0001\u0005i&lWM\u0003\u0003\u0003P\nE\u0017\u0002\u0002Bn\u0005;\fq!S7q_J$8O\u0003\u0003\u0003V\n]\u0017\u0002\u0002Bq\u0005G\u0014\u0001\u0002R1uKRKW.Z\u0005\u0005\u0005K\u0014iNA\u0006UsB,\u0017*\u001c9peR\u001c\u0018\u0001\u0003:fO&\u001cH/\u001a:\u0015\t\u0005]\"1\u001e\u0005\b\u0005[4\u0003\u0019\u0001Bx\u0003\u0011\u0019\b/Z2\u0011\u0007%\u0013\t0C\u0002\u0003tR\u0012\u0011\u0003V1tWN\u0003XmY5gS\u000e\fG/[8o\u0003i\u0001(/\u001a9be\u0016\u0014v\u000e\u001c7cC\u000e\\\u0017I\u001c3SK\u001eL7\u000f^3s)\u0019\t9D!?\u0003|\"9\u0011QG\u0014A\u0002\u0005]\u0002b\u0002B\u007fO\u0001\u0007!q^\u0001\re>dGNY1dWN\u0003XmY\u0001\u000bI>\u0014VmZ5ti\u0016\u0014HCBA\u001c\u0007\u0007\u00199\u0001\u0003\u0004\u0004\u0006!\u0002\rA\\\u0001\ni\u0006\u001c8.Q2u_JDqA!<)\u0001\u0004\u0011y/A\bde\u0016\fG/\u001a+bg.\f5\r^8s)\u0015q7QBB\t\u0011\u001d\u0019y!\u000ba\u0001\u0005_\fQb\u001d9fG&4\u0017nY1uS>t\u0007\"CB\nSA\u0005\t\u0019AB\u000b\u00035\u0019H/[2ls\u0006#GM]3tgB\u0019ama\u0006\n\u0007\reqMA\u0004BI\u0012\u0014Xm]:\u00023\r\u0014X-\u0019;f)\u0006\u001c8.Q2u_J$C-\u001a4bk2$HEM\u000b\u0003\u0007?QCa!\u0006\u0002^\u0005)r-\u001a;BY2LenY8na2,G/\u001a+bg.\u001cH\u0003BB\u0013\u0007g\u0001b!!!\u0002\b\u000e\u001d\u0002\u0003BB\u0015\u0007_i!aa\u000b\u000b\u0007\r5\u0002-A\u0005fq\u0016\u001cW\u000f^5p]&!1\u0011GB\u0016\u00055!\u0016m]6XSRD'\t\\8dW\"I1QG\u0016\u0011\u0002\u0003\u00071qG\u0001\nM\u0016$8\r['pI\u0016\u0004Ba!\u000b\u0004:%!11HB\u0016\u0005%1U\r^2i\u001b>$W-A\u0010hKR\fE\u000e\\%oG>l\u0007\u000f\\3uKR\u000b7o[:%I\u00164\u0017-\u001e7uIE*\"a!\u0011+\t\r]\u0012QL\u0001\u0015e\u0016\u0014XmZ5ti\u0016\u0014x\t[8tiR\u000b7o[:\u0015\u0005\r\u001d\u0003CBAA\u0003\u000f\u0013)*\u0001\bbg.$\u0015n\u001d;sS\n,Ho\u001c:\u0016\t\r531\u000b\u000b\u0005\u0007\u001f\u001aY\u0006\u0006\u0003\u0004R\rU\u0003\u0003\u0002B@\u0007'\"qAa!/\u0005\u0004\u0011)\tC\u0004\u0004X9\u0002\ra!\u0017\u0002\u0013=tG+[7f_V$\b\u0003CA\u0015\u0005g\u00129h!\u0015\t\u000f\ruc\u00061\u0001\u0003\u000e\u0006\u0019Qn]4\u0002\u0011\u0005\u001c8.Q2u_J,Baa\u0019\u0004jQ11QMB8\u0007c\"Baa\u001a\u0004lA!!qPB5\t\u001d\u0011\u0019i\fb\u0001\u0005\u000bCqaa\u00160\u0001\u0004\u0019i\u0007\u0005\u0005\u0002*\tM$qOB4\u0011\u0015Aw\u00061\u0001o\u0011\u001d\u0019if\fa\u0001\u0005\u001b+Ba!\u001e\u0004|Q11qOBA\u0007\u0007#Ba!\u001f\u0004~A!!qPB>\t\u001d\u0011\u0019\t\rb\u0001\u0005\u000bCqaa\u00161\u0001\u0004\u0019y\b\u0005\u0005\u0002*\tM$qOB=\u0011\u0019A\u0007\u00071\u0001\u0003F!91Q\f\u0019A\u0002\t5\u0015!\u00023p\u0003N\\W\u0003BBE\u0007\u001f#Baa#\u0004\u0016R!1QRBI!\u0011\u0011yha$\u0005\u000f\t\r\u0015G1\u0001\u0003\u0006\"91qK\u0019A\u0002\rM\u0005\u0003CA\u0015\u0005g\u00129h!$\t\u000f\r]\u0015\u00071\u0001\u0004\u001a\u0006!1/\u001a8e!!\tIca'\u0004 \u000e%\u0016\u0002BBO\u0003W\u0011\u0011BR;oGRLwN\\\u0019\u0011\t\r\u00056QU\u0007\u0003\u0007GS1!!\"j\u0013\u0011\u00199ka)\u0003\u000fQKW.Z8viB111VBY\u0005\u001bk!a!,\u000b\t\r=\u00161F\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BBZ\u0007[\u0013\u0011\"Q<bSR\f'\r\\3\u0002\u001dI,G\u000f\u001b:po>sWI\u001d:peV!1\u0011XB`+\t\u0019Y\f\u0005\u0005\u0002*\tM$qOB_!\u0011\u0011yha0\u0005\u000f\t\r%G1\u0001\u0003\u0006\u0002")
public class TaskExecutionEngine
implements IEngine,
Logging {
    private final ActiveTaskRepository taskRepository;
    private final TaskExecutionWorkerRepository workerRepository;
    private final ActorSystem system;
    private final ActorRef workerManager;
    private final TaskFinalizer taskFinalizer;
    private final CommonSettings commonSettings;
    private final TaskerSettings taskerSettings;
    private final ActorRef distributor;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void cancel(String taskid) {
        IEngine.super.cancel(taskid);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TaskExecutionEngine taskExecutionEngine = this;
        synchronized (taskExecutionEngine) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private CommonSettings commonSettings() {
        return this.commonSettings;
    }

    private TaskerSettings taskerSettings() {
        return this.taskerSettings;
    }

    private ActorRef distributor() {
        return this.distributor;
    }

    @Override
    public void cancel(String taskid, boolean force) {
        this.taskFinalizer.cancel(this.lookupTaskActor(taskid), taskid, RunMode$.MODULE$.withForce(force));
    }

    public boolean cancel$default$2() {
        return false;
    }

    @Override
    public void archive(String taskid) {
        this.taskFinalizer.archive(this.lookupTaskActor(taskid), taskid);
    }

    @Override
    public void skipSteps(String taskid, java.util.List<Integer> stepNrs) {
        this.skipStepPaths(taskid, (Seq<BlockPath>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stepNrs).asScala()).map((Function1 & Serializable & scala.Serializable)oldPosition -> this.int2BlockPath((Integer)oldPosition), Buffer$.MODULE$.canBuildFrom())));
    }

    private void skipStepPaths(String taskid, Seq<BlockPath> stepNrs) {
        this.manageStep(taskid, new SkipSteps(taskid, stepNrs));
    }

    private void manageStep(String taskid, ModifySteps message) {
        ActorRef x$3;
        Timeout x$2;
        ModifySteps x$1;
        Timeout timeout = this.taskerSettings().askTimeout();
        ActorSelection qual$1 = akka.pattern.package$.MODULE$.ask(this.lookupTaskActor(taskid));
        Object object = Await$.MODULE$.result((Awaitable)AskableActorSelection$.MODULE$.$qmark$extension1(qual$1, (Object)(x$1 = message), x$2 = timeout, x$3 = AskableActorSelection$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1)), (Duration)timeout.duration());
        if (object instanceof StepModificationError) {
            StepModificationError stepModificationError = (StepModificationError)object;
            throw new TaskerException(stepModificationError.msg());
        }
        if (object instanceof PathsNotFound) {
            PathsNotFound pathsNotFound = (PathsNotFound)object;
            Seq<BlockPath> paths = pathsNotFound.paths();
            throw new TaskerException(new StringBuilder(55).append("Cannot find a path to add a pause step at the position ").append(paths).toString());
        }
        if (object instanceof ActorNotFound) {
            throw new RuntimeException("Probably connection to satellite is lost");
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private BlockPath int2BlockPath(Integer oldPosition) {
        return BlockPath$Root$.MODULE$.$div(1).$div(1).$div(Predef$.MODULE$.Integer2int(oldPosition));
    }

    @Override
    public void unskipSteps(String taskid, java.util.List<Integer> stepNrs) {
        this.unskipStepPaths(taskid, (Seq<BlockPath>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stepNrs).asScala()).map((Function1 & Serializable & scala.Serializable)oldPosition -> this.int2BlockPath((Integer)oldPosition), Buffer$.MODULE$.canBuildFrom())));
    }

    private void unskipStepPaths(String taskid, Seq<BlockPath> stepNrs) {
        this.manageStep(taskid, new UnSkipSteps(taskid, stepNrs));
    }

    @Override
    public void addPauseStep(String taskid, Integer position) {
        this.addPauseStep(taskid, this.int2BlockPath(position));
    }

    @Override
    public void addPauseStep(String taskid, BlockPath position) {
        this.manageStep(taskid, new AddPauseStep(taskid, position));
    }

    @Override
    public void unskipStepPaths(String taskid, java.util.List<BlockPath> stepNrs) {
        this.unskipStepPaths(taskid, (Seq<BlockPath>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(stepNrs).asScala()));
    }

    @Override
    public void skipStepPaths(String taskid, java.util.List<BlockPath> stepNrs) {
        this.skipStepPaths(taskid, (Seq<BlockPath>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(stepNrs).asScala()));
    }

    @Override
    public void stop(String taskid) {
        ScalaActorSelection qual$1 = ActorSelection$.MODULE$.toScala(this.lookupTaskActor(taskid));
        Stop x$1 = new Stop(taskid);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    @Override
    public void abort(String taskid) {
        ScalaActorSelection qual$1 = ActorSelection$.MODULE$.toScala(this.lookupTaskActor(taskid));
        Abort x$1 = new Abort(taskid);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    @Override
    public void execute(String taskid) {
        Timeout askTimeout = this.taskerSettings().askTimeout();
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ActorSelection qual$1 = akka.pattern.package$.MODULE$.ask(this.lookupTaskActor(taskid));
            Enqueue x$1 = new Enqueue(taskid);
            Timeout x$2 = askTimeout;
            ActorRef x$3 = AskableActorSelection$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            return (Future)Await$.MODULE$.ready((Awaitable)AskableActorSelection$.MODULE$.$qmark$extension1(qual$1, (Object)x$1, x$2, x$3), (Duration)askTimeout.duration().$plus(new package.DurationInt(package$.MODULE$.DurationInt(100)).millis()));
        });
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable cause = failure.exception();
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Enqueue task ").append(taskid).append(" failed due the ").append(cause.getMessage()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Task ").append(taskid).append(" enqued").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public Task retrieve(String taskid) {
        return (Task)((TaskDistributor.messages.TaskFound)this.askActor(this.chunkReceiver(this.lookupTaskActorParent(taskid)), (Object)new TaskDistributor.messages.RetrieveTask(taskid), this.taskNotFoundOnError(taskid))).task().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw this.com$xebialabs$deployit$engine$tasker$TaskExecutionEngine$$taskNotFoundException(taskid);
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Task assign(String taskid, Authentication owner) {
        void var3_3;
        Task task = (Task)((TaskDistributor.messages.TaskFound)this.askActor(this.chunkReceiver(this.lookupTaskActorParent(taskid)), (Object)new TaskDistributor.messages.AssignTask(taskid, owner), this.taskNotFoundOnError(taskid))).task().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw this.com$xebialabs$deployit$engine$tasker$TaskExecutionEngine$$taskNotFoundException(taskid);
        });
        this.taskRepository.changeOwner(taskid, task.getOwner());
        return var3_3;
    }

    private ActorRef chunkReceiver(ActorSelection parent) {
        return this.system.actorOf(Props$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new ChunkReceivingForwarder(parent), ClassTag$.MODULE$.apply(ChunkReceivingForwarder.class)));
    }

    public ActorSelection lookupTaskActor(String taskid) {
        return (ActorSelection)this.getActorPathFromRepository(taskid).map((Function1 & Serializable & scala.Serializable)path -> $this.system.actorSelection(path)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw this.com$xebialabs$deployit$engine$tasker$TaskExecutionEngine$$taskNotFoundException(taskid);
        });
    }

    public ActorSelection lookupTaskActorParent(String taskid) {
        return (ActorSelection)this.getActorPathFromRepository(taskid).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.$div("..")).map((Function1 & Serializable & scala.Serializable)path -> $this.system.actorSelection(path)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw this.com$xebialabs$deployit$engine$tasker$TaskExecutionEngine$$taskNotFoundException(taskid);
        });
    }

    private Option<ActorPath> getActorPathFromRepository(String taskId) {
        return this.taskRepository.workerAddress(taskId).map((Function1 & Serializable & scala.Serializable)wa -> ActorPath$.MODULE$.fromString(new StringBuilder(7).append((String)wa).append("/user/").append(TasksManager$.MODULE$.name()).append("/").append(taskId).toString()));
    }

    private <T> PartialFunction<Throwable, T> taskNotFoundOnError(String taskId) {
        return new scala.Serializable(this, taskId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TaskExecutionEngine $outer;
            private final String taskId$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof TimeoutException) {
                    throw this.$outer.com$xebialabs$deployit$engine$tasker$TaskExecutionEngine$$taskNotFoundException(this.taskId$2);
                }
                if (A1 != null) {
                    A1 A12 = A1;
                    throw A12;
                }
                Object object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof TimeoutException ? true : throwable != null;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.taskId$2 = taskId$2;
            }
        };
    }

    public <T> TaskNotFoundException com$xebialabs$deployit$engine$tasker$TaskExecutionEngine$$taskNotFoundException(String taskId) {
        return new TaskNotFoundException("registry", taskId);
    }

    @Override
    public void schedule(String taskid, DateTime scheduleAt) {
        long tickMillis;
        if (scheduleAt.isBeforeNow()) {
            throw new TaskerException(new StringBuilder(66).append("Cannot schedule a task for the past, date entered was [").append(TaskExecutionEngine.p$1(scheduleAt)).append(", now is [").append(TaskExecutionEngine.p$1(Imports$.MODULE$.DateTime().now())).append("]").toString());
        }
        long delayMillis = RichReadableInterval$.MODULE$.millis$extension(Imports$.MODULE$.richReadableInterval((ReadableInterval)RichReadableInstant$.MODULE$.to$extension(Imports$.MODULE$.richReadableInstant((ReadableInstant)Imports$.MODULE$.DateTime().now()), (ReadableInstant)scheduleAt)));
        if (delayMillis > (long)Integer.MAX_VALUE * (tickMillis = this.taskerSettings().tickDuration().toMillis())) {
            DateTime time = new DateTime((Object)RichDateTime$.MODULE$.millis$extension(Imports$.MODULE$.richDateTime(Imports$.MODULE$.DateTime().now())).addToCopy(tickMillis * Integer.MAX_VALUE));
            throw new TaskerException(new StringBuilder(93).append("Cannot schedule task [").append(taskid).append("] at [").append(TaskExecutionEngine.p$1(scheduleAt)).append("], because it is too far into the future. Can only schedule to [").append(TaskExecutionEngine.p$1(time)).append("]").toString());
        }
        ScalaActorSelection qual$1 = ActorSelection$.MODULE$.toScala(this.lookupTaskActor(taskid));
        TaskManagingActor.messages.Schedule x$1 = new TaskManagingActor.messages.Schedule(taskid, scheduleAt);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
    }

    @Override
    public String register(TaskSpecification spec) {
        return this.doRegister(this.createTaskActor(spec, this.createTaskActor$default$2()), spec);
    }

    @Override
    public String prepareRollbackAndRegister(String taskid, TaskSpecification rollbackSpec) {
        ActorSelection parent = this.lookupTaskActorParent(taskid);
        this.askActor(parent, (Object)new TaskDistributor.messages.PrepareRollbackTask(taskid), this.rethrowOnError());
        ActorRef forwarder = this.system.actorOf(Props$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new ChunkSendingForwarder(parent, this.commonSettings().inProcessTaskEngine()), ClassTag$.MODULE$.apply(ChunkSendingForwarder.class)));
        Integer workerId = (Integer)this.taskRepository.task(taskid).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.workerId()).get();
        return this.doRegister(((TaskDistributor.messages.TaskActorCreated)this.askActor(forwarder, (Object)new TaskDistributor.messages.CreateTaskActor(rollbackSpec, workerId), this.rethrowOnError())).taskActor(), rollbackSpec);
    }

    /*
     * WARNING - void declaration
     */
    private String doRegister(ActorRef taskActor, TaskSpecification spec) {
        void var3_3;
        String taskId = ((Registered)this.askActor(taskActor, (Object)new TaskManagingActor.messages.Register(), this.rethrowOnError())).taskId();
        this.taskRepository.store(taskId, spec, taskActor.path());
        return var3_3;
    }

    private ActorRef createTaskActor(TaskSpecification specification, Address stickyAddress) {
        return ((TaskDistributor.messages.TaskActorCreated)this.askDistributor(new TaskDistributor.messages.CreateTaskActor(specification, TaskDistributor$messages$CreateTaskActor$.MODULE$.apply$default$2()), this.rethrowOnError())).taskActor();
    }

    private Address createTaskActor$default$2() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public java.util.List<TaskWithBlock> getAllIncompleteTasks(FetchMode fetchMode) {
        void var3_3;
        List<ActiveTask> tasks = this.taskRepository.tasks();
        ArrayList result = new ArrayList((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(tasks).asJava());
        Map idxs = ((TraversableOnce)((IterableLike)tasks.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), List$.MODULE$.canBuildFrom())).zipWithIndex(List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Seq<TaskWithBlock> details = ((TaskDistributor.messages.TasksFound)this.askDistributor(new TaskDistributor.messages.RetrieveAllTasks(fetchMode), this.rethrowOnError())).tasks();
        details.foreach((Function1 & Serializable & scala.Serializable)t -> {
            BoxedUnit boxedUnit;
            Option option = idxs.get((Object)t.getId());
            if (option instanceof Some) {
                Some some = (Some)option;
                int idx = BoxesRunTime.unboxToInt((Object)some.value());
                boxedUnit = result.set(idx, t);
            } else if (None$.MODULE$.equals(option)) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("Found ghost task [").append(t.getId()).append("]. This task is not registered in the system, but found on a worker.").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            return boxedUnit;
        });
        return var3_3;
    }

    public FetchMode getAllIncompleteTasks$default$1() {
        return FetchMode.FULL;
    }

    @Override
    public java.util.List<String> reregisterGhostTasks() {
        Timeout timeout = this.taskerSettings().askTimeout();
        Props props = Props$.MODULE$.apply(ReRegisterGhostTasksAggregator.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.taskRepository, this.workerRepository, BoxesRunTime.boxToBoolean((boolean)this.commonSettings().inProcessTaskEngine())}));
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.workerManager);
        WorkerManager.messages.Publish x$1 = new WorkerManager.messages.Publish(TasksManager$.MODULE$.name(), this.system.actorOf(props));
        Timeout x$2 = timeout;
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        TaskDistributor.messages.GhostTasksReRegistered response = (TaskDistributor.messages.GhostTasksReRegistered)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$1, x$2, x$3), (Duration)timeout.duration());
        return new ArrayList<String>((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)response.tasks().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getId(), List$.MODULE$.canBuildFrom())).asJava());
    }

    private <T> T askDistributor(Object msg, PartialFunction<Throwable, T> onTimeout) {
        Object object;
        Timeout timeout = this.taskerSettings().askTimeout();
        try {
            Object object2;
            ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.distributor());
            Object x$1 = msg;
            Timeout x$2 = timeout;
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, x$1);
            Object object3 = Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, x$1, x$2, x$3), (Duration)timeout.duration());
            if (WorkerManager$messages$NoWorkersError$.MODULE$.equals(object3)) {
                throw new NoWorkersException("There are currently no workers available, tasks cannot be executed. Please contact your system administrator to correct the system.");
            }
            object = object2 = object3;
        }
        catch (Throwable x$5) {
            PartialFunction<Throwable, T> catchExpr$1 = onTimeout;
            if (catchExpr$1.isDefinedAt((Object)x$5)) {
                object = catchExpr$1.apply((Object)x$5);
            }
            throw x$5;
        }
        return (T)object;
    }

    private <T> T askActor(ActorRef actor, Object msg, PartialFunction<Throwable, T> onTimeout) {
        return this.doAsk((Function1<Timeout, Awaitable<Object>>)(Function1 & Serializable & scala.Serializable)t -> {
            ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(actor);
            Object x$1 = msg;
            Timeout x$2 = t;
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, x$1);
            return AskableActorRef$.MODULE$.$qmark$extension1(qual$1, x$1, x$2, x$3);
        }, onTimeout);
    }

    private <T> T askActor(ActorSelection actor, Object msg, PartialFunction<Throwable, T> onTimeout) {
        return this.doAsk((Function1<Timeout, Awaitable<Object>>)(Function1 & Serializable & scala.Serializable)t -> {
            ActorSelection qual$1 = akka.pattern.package$.MODULE$.ask(actor);
            Object x$1 = msg;
            Timeout x$2 = t;
            ActorRef x$3 = AskableActorSelection$.MODULE$.$qmark$default$3$extension(qual$1, x$1);
            return AskableActorSelection$.MODULE$.$qmark$extension1(qual$1, x$1, x$2, x$3);
        }, onTimeout);
    }

    private <T> T doAsk(Function1<Timeout, Awaitable<Object>> send, PartialFunction<Throwable, T> onTimeout) {
        Object object;
        Timeout timeout = this.taskerSettings().askTimeout();
        try {
            object = Await$.MODULE$.result((Awaitable)send.apply((Object)timeout), (Duration)timeout.duration());
        }
        catch (Throwable x$6) {
            PartialFunction<Throwable, T> catchExpr$2 = onTimeout;
            if (catchExpr$2.isDefinedAt((Object)x$6)) {
                object = catchExpr$2.apply((Object)x$6);
            }
            throw x$6;
        }
        return (T)object;
    }

    public <T> PartialFunction<Throwable, T> rethrowOnError() {
        return new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    throw A12;
                }
                Object object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable != null;
                return bl;
            }
        };
    }

    private static final String p$1(DateTime d) {
        return d.toString("yyyy-MM-dd HH:mm:ss Z");
    }

    public TaskExecutionEngine(ActiveTaskRepository taskRepository, TaskExecutionWorkerRepository workerRepository, ActorSystem system, ActorRef workerManager, TaskFinalizer taskFinalizer) {
        this.taskRepository = taskRepository;
        this.workerRepository = workerRepository;
        this.system = system;
        this.workerManager = workerManager;
        this.taskFinalizer = taskFinalizer;
        Logging.$init$((Logging)this);
        this.commonSettings = (CommonSettings)CommonSettings$.MODULE$.apply(system);
        this.taskerSettings = this.commonSettings().tasker();
        this.distributor = system.actorOf(TaskDistributor$.MODULE$.props(workerManager, this.commonSettings().inProcessTaskEngine()), TaskDistributor$.MODULE$.name());
    }
}

