package com.xebialabs.deployit.engine.tasker.distribution.versioning

import java.security.MessageDigest

import com.xebialabs.deployit.util.JavaCryptoUtils
import grizzled.slf4j.Logging

class TypeSafeItem(key: String, value: String) extends ConfigurationTreeItem with Logging {

  override def calculateSha1Hash: String = {
    if (sha1Hash == null) {
      val keyValue = key + ':' + value
      val sha1: MessageDigest = JavaCryptoUtils.getSha1
      sha1.update(keyValue.getBytes("UTF-8"))
      sha1Hash = JavaCryptoUtils.digest(sha1)
      trace(s"Using hash $sha1Hash for $keyValue")
    }
    sha1Hash
  }

}
