package com.xebialabs.deployit.engine.tasker.distribution.versioning

import java.io.File

import com.typesafe.config.Config
import grizzled.slf4j.Logging

object ConfigurationHasher extends Logging {

  def generateConfigurationHash(files: Seq[File], configs: Seq[Config], whitelistedPaths: Seq[String], blacklistedPaths: Set[String]): String = {
    val configurationTree: ConfigurationTree = new ConfigurationTree()
    files.foreach(file => {
      if(file.isDirectory) {
        trace(s"Adding directory ${file.getPath} ${file.getName}")
        configurationTree.addChild(new DirectoryItem(file))
      }
      else {
        trace(s"Adding file ${file.getPath} ${file.getName}")
        configurationTree.addChild(new FileItem(file))
      }
    })
    configs.foreach(config => {
      configurationTree.addChild(new TypeSafeConfiguration(config, whitelistedPaths, blacklistedPaths))
    })
    configurationTree.calculateSha1Hash
  }

}
