package com.xebialabs.deployit.engine.tasker.distribution

import java.io.File

import akka.actor.{ActorRef, ActorRefFactory}
import com.xebialabs.deployit.engine.spi.services.RepositoryFactory
import com.xebialabs.deployit.engine.tasker.{Task, TaskManagingActor, TaskSpecification}

class TaskActorCreatorImpl(repositoryFactory: RepositoryFactory, archiver: ActorRef) extends TaskActorCreator {

  override def create(taskSpecification: TaskSpecification, workerId: Integer, factory: ActorRefFactory): ActorRef = {
    val task = new Task(taskSpecification.getId, taskSpecification, workerId)
    task.context.repository = repositoryFactory.create(new File(taskSpecification.getWorkDir.getPath))
    create(task, factory)
  }

  override def create(task: Task, factory: ActorRefFactory): ActorRef = {
    factory.actorOf(TaskManagingActor.props(task, archiver), task.getId)
  }
}
