package com.xebialabs.deployit.engine.tasker.distribution.versioning

import java.security.MessageDigest

import com.xebialabs.deployit.util.JavaCryptoUtils

import scala.collection.mutable

trait ParentItem extends ConfigurationTreeItem {

  object HashAlphabetOrdering extends Ordering[ConfigurationTreeItem] {

    def compare(first: ConfigurationTreeItem, second: ConfigurationTreeItem): Int = first.calculateSha1Hash.compareTo(second.calculateSha1Hash)

  }

  var children: mutable.TreeSet[ConfigurationTreeItem] = new mutable.TreeSet[ConfigurationTreeItem]()(HashAlphabetOrdering)

  override def calculateSha1Hash: String = {
    if (sha1Hash == null) {
      val sha1: MessageDigest = JavaCryptoUtils.getSha1
      children.foreach(item => sha1.update(item.calculateSha1Hash.getBytes("UTF-8")))
      sha1Hash = JavaCryptoUtils.digest(sha1)
    }
    sha1Hash
  }

  def addChild(configurationTreeItem: ConfigurationTreeItem): Unit = {
    invalidateSha1Hash()
    children += configurationTreeItem
  }

}
