package com.xebialabs.deployit.engine.tasker.distribution.versioning

import java.io.File

import grizzled.slf4j.Logging

class DirectoryItem(directory: File) extends ParentItem with Logging {

  directory.listFiles().foreach(file => {
    if(file.isDirectory) {
      trace(s"Adding directory ${file.getPath} ${file.getName}")
      addChild(new DirectoryItem(file))
    }
    else {
      trace(s"Adding file ${file.getPath} ${file.getName}")
      addChild(new FileItem(file))
    }
  })

}
