package com.xebialabs.deployit.engine.tasker.repository

import java.util

import akka.actor.ActorPath
import com.xebialabs.deployit.engine.api.execution.{BlockState, TaskExecutionState, TaskPackageDependency, TaskWithBlock}
import com.xebialabs.deployit.engine.tasker.{Description, Task, TaskId, TaskSpecification}
import org.joda.time.DateTime

import scala.beans.BeanProperty

trait ActiveTaskRepository extends CleanupActiveTaskRepository {

  def store(taskId: TaskId, spec: TaskSpecification, path: ActorPath)

  def changeOwner(taskId: TaskId, newOwner: String)

  def workerAddress(taskId: TaskId): Option[String]

  def task(taskId: TaskId): Option[ActiveTask]

  def tasks(): List[ActiveTask]

}

trait CleanupActiveTaskRepository {

  def delete(taskId: TaskId)

}

class ActiveTask(
                  @BeanProperty val id: TaskId,
                  @BeanProperty val description: Description,
                  @BeanProperty val owner: String,
                  @BeanProperty val metadata: util.Map[String, String],
                  @BeanProperty val workerId: Integer
                ) extends TaskWithBlock {

  override def getBlock: BlockState = null

  override def getActiveBlocks: util.List[TaskId] = null

  override def getState: TaskExecutionState = null

  override def getScheduledDate: DateTime = null

  override def getStartDate: DateTime = null

  override def getCompletionDate: DateTime = null

  override def getFailureCount: Int = 0

  override def getPackageDependencies: util.List[TaskPackageDependency] = null
}

class WorkerInfo(@BeanProperty val id: Int, @BeanProperty val name: String)