package com.xebialabs.deployit.engine.tasker.distribution.versioning

import java.io.{BufferedInputStream, File, FileInputStream, InputStream}
import java.security.MessageDigest

import com.xebialabs.deployit.util.JavaCryptoUtils
import grizzled.slf4j.Logging

class FileItem(file: File) extends ConfigurationTreeItem with Logging {

  var BUFFER_SIZE: Int = 512

  override def calculateSha1Hash: String = {
    if (sha1Hash == null) {
      val sha1: MessageDigest = JavaCryptoUtils.getSha1
      sha1.update(file.getName.getBytes("UTF-8"))
      if (file.exists()) {
        updateDigest(sha1, new BufferedInputStream(new FileInputStream(file)))
      }
      sha1Hash = JavaCryptoUtils.digest(sha1)
      trace(s"Using hash $sha1Hash for ${file.getName}")
    }
    sha1Hash
  }

  def updateDigest(digest: MessageDigest, data: InputStream): MessageDigest = {
    val buffer = new Array[Byte](BUFFER_SIZE)
    var read = data.read(buffer, 0, BUFFER_SIZE)
    while (read > -1) {
      digest.update(buffer, 0, read)
      read = data.read(buffer, 0, BUFFER_SIZE)
    }
    digest
  }

}
