package com.xebialabs.deployit.engine.tasker

import akka.actor.{Actor, Props}
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState
import com.xebialabs.deployit.engine.tasker.messages.TaskDone
import grizzled.slf4j.Logging

object TaskTransitionActor {
  def props(engine: TaskExecutionEngine) = Props(classOf[TaskTransitionActor], engine).withDispatcher(stateManagementDispatcher)

  val name = "task-transition-actor"
}

class TaskTransitionActor(engine: TaskExecutionEngine) extends Actor with Logging {

  import context._

  override def preStart(): Unit = {
    system.eventStream.subscribe(self, classOf[TaskDone])
    super.preStart()
  }

  def receive: Actor.Receive = ReceiveWithMdc() {
    case TaskDone(task) if task.getSpecification.isNonInteractive && task.getState == TaskExecutionState.EXECUTED =>
      info(s"Automatically transition task [${task.getId}] to DONE state")
      engine.archive(task.getId)
    case TaskDone(task) if task.getSpecification.isNonInteractive && task.getState.isExecutionHalted =>
      info(s"Automatically transition task [${task.getId}] to CANCELLED state")
      engine.cancel(task.getId)
    case _ =>
  }

}

