package com.xebialabs.deployit.engine.tasker.satellite

import akka.actor._
import com.xebialabs.xlplatform.satellite.Satellite

trait ActorLocator {

  def locate(remotePath: ActorPath)(implicit actorSystem: ActorSystem): ActorSelection
}

object ActorLocator {

  def apply(satellite: Satellite): ActorLocator = SatelliteActorLocator(satellite)

  def apply(): ActorLocator = LocalActorLocator
}

private case class SatelliteActorLocator(satellite: Satellite) extends ActorLocator with Serializable {

  override def locate(remotePath: ActorPath)(implicit actorSystem: ActorSystem): ActorSelection = {
    val remoteAddress = remotePath.toSerializationFormatWithAddress(address)
    actorSystem.actorSelection(remoteAddress)
  }

  private def address: Address =
    Address(protocol, Paths.systemName, satellite.getAddress, satellite.getProtocolPort)

  private def protocol: String =
    if (satellite.isEncrypted) {
      "akka.ssl.tcp"
    } else {
      "akka.tcp"
    }
}

case object LocalActorLocator extends ActorLocator with Serializable {

  override def locate(remotePath: ActorPath)(implicit actorSystem: ActorSystem): ActorSelection = {
    actorSystem.actorSelection(remotePath)
  }
}
