package com.xebialabs.deployit.engine

import akka.actor.{ActorContext, ActorRef, Props}

package object tasker {
  type Cache[A, B] = collection.mutable.Map[A, B]
  val Cache = collection.mutable.Map

  type TaskId = String
  type BlockId = String
  type Description = String
  type StepId = String
  val stateManagementDispatcher = "task.state-management-dispatcher"
  val stateEventListenerDispatcher = "task.state-event-listener-dispatcher"
  val stepDispatcher = "task.step-dispatcher"
  val archiveDispatcher = "task.archive-dispatcher"

  trait ActorCreationSupport {
    def createChild(props: Props, name: String): ActorRef
  }

  trait ActorContextCreationSupport extends ActorCreationSupport {
    def context: ActorContext
    def createChild(props: Props, name: String): ActorRef = context.actorOf(props, name)
    def createChild(props: Props): ActorRef = context.actorOf(props)
  }
}
