package com.xebialabs.deployit.engine.tasker;

import java.util.HashMap;
import java.util.Map;

import com.xebialabs.deployit.booter.local.utils.Strings;
import org.joda.time.DateTime;

import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.plugin.api.flow.Preview;
import com.xebialabs.deployit.plugin.api.flow.PreviewStep;
import com.xebialabs.deployit.plugin.api.flow.Step;


public class PreviewStepAdapter implements StepState {

    private TaskStep adaptee;

    private Map<String, String> metadata;

    public PreviewStepAdapter(TaskStep adaptee) {
        this.adaptee = adaptee;
        metadata = new HashMap<>(adaptee.getMetadata());
        calculatePreview();
    }

    private void calculatePreview() {
        Step implementation = adaptee.getImplementation();
        if (implementation instanceof PreviewStep) {
            Preview preview = ((PreviewStep) implementation).getPreview();
            String contents = Strings.defaultIfEmpty(preview.getContents(), "").replace("\r\n", "\n");
            metadata.put("contents", contents);
            metadata.put("sourcePath", Strings.defaultIfEmpty(preview.getSourcePath(), ""));
        }
    }

    @Override
    public String getDescription() {
        return adaptee.getDescription();
    }

    @Override
    public StepExecutionState getState() {
        return adaptee.getState();
    }

    @Override
    public String getLog() {
        return adaptee.getLog();
    }

    @Override
    public DateTime getStartDate() {
        return adaptee.getStartDate();
    }

    @Override
    public DateTime getCompletionDate() {
        return adaptee.getCompletionDate();
    }

    @Override
    public int getFailureCount() {
        return adaptee.getFailureCount();
    }

    @Override
    public Map<String, String> getMetadata() {
        return metadata;
    }

    @Override
    public boolean getSkippable() {
        return adaptee.getSkippable();
    }
}
